package com.zjty.project.state.server.service;

import com.zjty.project.state.server.dao.FileDao;
import com.zjty.project.state.server.dao.GoalDao;
import com.zjty.project.state.server.dao.PlanRoleDao;
import com.zjty.project.state.server.pojo.File;
import com.zjty.project.state.server.pojo.Goal;
import com.zjty.project.state.server.pojo.project.Project;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <h4>Description : 里程碑管理</h4>
 *
 * @author : czq
 * @Date : 2020-02-27 10:43
 */
@Service
public class GoalService {

    private final GoalDao goalDao;

    private final PlanRoleDao planRoleDao;

    private final FileDao fileDao;

    @Autowired
    public GoalService(GoalDao goalDao, PlanRoleDao planRoleDao, FileDao fileDao) {
        this.goalDao = goalDao;
        this.planRoleDao = planRoleDao;
        this.fileDao = fileDao;
    }
    @Autowired
    private FileService fileService;

    /**
     * 新增里程碑
     * 1、新增里程碑的基本信息
     * 2、绑定操作人
     * 3、绑定文件
     * @param goal 里程碑
     * @return 成功
     */
//    public Goal addGoal(Goal goal) {
//        Goal newGoal = goalDao.save(goal);
//        /*
//        绑定文件
//         */
//        List<File> files = goal.getFiles();
//        for (File file:files) {
//            file.setGoalId(newGoal.getId());
//        }
//        fileDao.saveAll(files);
//        newGoal.setFiles(files);
//        /*
//        绑定操作人
//         */
//        List<PlanRole> planRoles = goal.getPlanRoles();
//        for (PlanRole planRole:planRoles) {
//            planRole.setGoalId(newGoal.getId());
//        }
//        planRoleDao.saveAll(planRoles);
//        newGoal.setPlanRoles(planRoles);
//        return newGoal;
//    }

    /**
     * 删除里程碑
     * 1、删除里程碑
     * 2、删除文件
     * 3、参与人无需解绑
     * @param goalId 里程碑id
     * @return
     */
//    @Transactional
//    public Goal deleteGoal(int goalId) {
//        //int goalId = goal.getId();
//        /*
//        删除里程碑
//         */
//        Goal one = goalDao.getOne(goalId);
//        one.setState(0);
//        /*
//        删除文件
//         */
//        List<File> files = fileDao.findFilesByGoalIdAndAndDeleted(goalId, 1);
//        for (File file:files) {
//            file.setDeleted(true);
//        }
//        one.setFiles(files);
//        return one;
//    }

    /**
     * 里程碑操作，包括提交、驳回、通过
     * 1、提交：里程碑状态改为待审核（默认为待提交）
     * 2、驳回：里程碑状态改为待提交
     * 3、通过：里程碑状态改为通过，并修改软件的进度
     *  goal 操作类型
     * @return 操作结果
     */
//    public ServerResponse work(Goal goal,Integer type) {
//        switch (type){
//            case 1:
//                goal.setState(1);
//                break;
//            case 2:
//                goal.setState(0);
//                break;
//            case 3:
//                goal.setState(2);
//
//                break;
//        }
//        return null;
//    }

    public void saveAll(List<Goal> goals, Project project) {
        if (goals!=null&&goals.size()>0&&project!=null){
            Date startTime = project.getStartTime();
            Date endTime = project.getEndTime();
            for (Goal goal:goals){
                goal.setStartTime(startTime);
                startTime = goal.getEndTime();
                Integer type = goal.getType();
                if (type.equals(3)){
                    goal.setEndTime(endTime);
                }
                goal.setProjectId(project.getId());
                save(goal,project.getId());
            }
        }
    }

    @Transactional(rollbackFor = Exception.class)
    public void save(Goal goal,Integer projectId) {
        List<File> files = goal.getFiles();
        goal = goalDao.save(goal);
        int goalId = goal.getId();
        fileService.creatAll(files,goalId,projectId);
    }

    public Map<String, Integer> getProcess(Integer projectId) {
        Map<String, Integer> map = new HashMap<>();
        Date date = new Date();
        map.put("expect", 0);
        map.put("actual", 0);
        Goal xuqiuGoal = goalDao.findByProjectIdAndType(projectId, 1);
        Boolean xuqiuProcess = fileService.getProcess(xuqiuGoal.getId());
        Date xuqiuStartTime = xuqiuGoal.getStartTime();
        Date xuqiuEndTime = xuqiuGoal.getEndTime();
        boolean beforeXuQiuStartTime = date.before(xuqiuStartTime);
        boolean beforeXuQiuEndTime = date.before(xuqiuEndTime);
        //判断当前所处阶段
        if (beforeXuQiuStartTime) {
            //当前时间在需求开始前
            return map;
        } else {
            if (beforeXuQiuEndTime) {
                map.put("expect", 1);
                map.put("actual", 1);
                return map;
            } else {
                Goal chuyanGoal = goalDao.findByProjectIdAndType(projectId, 2);
                Boolean chuyanProcess = fileService.getProcess(chuyanGoal.getId());
                Date chuyanStartTime = chuyanGoal.getStartTime();
                Date chuyanEndTime = chuyanGoal.getEndTime();
                boolean beforeChuYanStartTime = date.before(chuyanStartTime);
                boolean beforeChuYanEndTime = date.before(chuyanEndTime);
                if (beforeChuYanStartTime) {
                    //当前时间在需求开始前
                    return map;
                } else {
                    if (beforeChuYanEndTime) {
                        if (xuqiuProcess) {
                            map.put("actual", 2);
                        } else {
                            map.put("actual", 1);
                        }
                        map.put("expect", 2);
                        return map;
                    } else {
                        Goal zhongyanGoal = goalDao.findByProjectIdAndType(projectId, 3);
                        Boolean zhongyanProcess = fileService.getProcess(zhongyanGoal.getId());
                        Date zhongyanStartTime = zhongyanGoal.getStartTime();
                        Date zhongyanEndTime = zhongyanGoal.getEndTime();
                        boolean beforeZhongYanStartTime = date.before(zhongyanStartTime);
                        boolean beforeZhongYanEndTime = date.before(zhongyanEndTime);
                        if (beforeZhongYanEndTime){
                            if (xuqiuProcess) {
                                if (chuyanProcess) {
                                    map.put("actual", 3);
                                }else {
                                    map.put("actual", 2);
                                }
                            } else {
                                map.put("actual", 1);
                            }
                            map.put("expect", 3);
                        }else {
                            if (xuqiuProcess) {
                                if (chuyanProcess) {
                                    if (zhongyanProcess) {
                                        map.put("actual", 4);
                                    }else {
                                        map.put("actual", 3);
                                    }
                                }else {
                                    map.put("actual", 2);
                                }
                            } else {
                                map.put("actual", 1);
                            }
                            map.put("expect", 4);
                        }
                    }
                }
            }
        }
        return map;

    }


    public List<Goal> findByProjectId(Integer projectId) {
        return goalDao.findAllByProjectId(projectId);
    }


}
