package com.zjty.project.state.server.service;

import com.zjty.project.state.server.dao.TechProduceDao;
import com.zjty.project.state.server.pojo.Tech;
import com.zjty.project.state.server.pojo.TechProduce;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * @program: state
 * @description:
 * @author: LiuJie
 * @create: 2020-02-27 12:49
 **/
@Service
public class TechProduceService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private TechProduceDao techProduceDao;

    @Transactional(rollbackFor = Exception.class)
    public void addAll(ArrayList<TechProduce> list) {
        techProduceDao.saveAll(list);
    }
    /**
    * @Description: 根据技术路线Id,查询该技术路线下的产品组合Id
    * @Param:
    * @return:
    * @Author: LiuJie
    * @Date: 2020/2/27
    */
    public List<Integer> findProduceByTech(Integer techId) {
        return techProduceDao.findProduce(techId);
    }
    /**
    * @Description: 根据产品Id,查询该产品参与的技术路线Id
    * @Param:
    * @return:
    * @Author: LiuJie
    * @Date: 2020/2/27
    */
    public List<Integer> findTechByProduce(Integer techId) {
        return techProduceDao.findTech(techId);
    }

    @Transactional(rollbackFor = Exception.class)
    public void update(Tech tech) {
        Integer id = tech.getId();
        if (id!=null){
            deleteByTechId(id);
            ArrayList<TechProduce> list = new ArrayList<>();
            List<Integer> produceList = tech.getProduceList();
            for (Integer produceId:produceList){
                list.add(new TechProduce(null,id,produceId));
            }
            addAll(list);
        }
    }

    @Transactional(rollbackFor = Exception.class)
    public void deleteByTechId(Integer techId) {
        techProduceDao.deleteAllByTechId(techId);

    }

}
