package com.zjty.project.state.thread.pool;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @program: bserver-parent
 * @description: 线程池属性配置类
 * @author: LiuJie
 * @create: 2019-05-20 16:01
 **/
@Data
@ConfigurationProperties(prefix = "thread.pool")
public class ThreadPoolConfig {
    /**
     * 核心线程池大小
     */
    private int corePoolSize;
    /**
     * 最大线程数
     */
    private int maxPoolSize;
    /**
     * 活跃时间
     */
    private int keepAliveSeconds;
    /**
     * 队列容量
     */
    private int queueCapacity;
}
