package com.zjty.project.inspect.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * <h4>Description : 框架难度</h4>
 *
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 * @Date : 2020-03-05 19:14
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "框架难度")
public class FrameDifficulty {
    //系统评估、额外信息、综合难度
    /**
     * 系统评估
     */
    private double systemEvaluation;

    /**
     * 额外信息
     */
    private double message;

    /**
     * 综合难度
     */
    private double difficulty;

    /**
     * 工作量
     */
    private double load;

    /**
     * 详情 1：混合 2：前后端分离
     */
    @ApiModelProperty(value = "详情 1：混合 2：前后端分离",example = "1")
    private Integer details;

    /**
     * 分布式 int 1：是 2：否
     */
    @ApiModelProperty(value = "分布式 int 1：是 2：否",example = "1")
    private Integer distributed;

    /**
     * 负载均衡 int 1：是 2：否
     */
    @ApiModelProperty(value = "负载均衡 int 1：是 2：否",example = "1")
    private Integer loadBalance;

    /**
     * 容灾 int 1：是 2：否
     */
    @ApiModelProperty(value = "容灾 int 1：是 2：否",example = "1")
    private Integer disaster;

    /**
     * 其他需求
     */
    private String otherDemand;
}
