package com.zjty.project.inspect.service;


import com.zjty.project.inspect.entity.*;

import java.util.List;
import java.util.Map;

/**
 * 规则接口
 */
public interface RuleService {

    /**
     * 新增规则
     * @param ruleQo 规则封装类
     */
    public void addRule(RuleQo ruleQo);

    public void addRule(List<Rule> rules);
    /**
     * 修改规则
     * @param ruleQo 规则封装类
     */
    public void upRule(RuleQo ruleQo);

    /**
     * 删除规则
     * @param ruleQo 规则封装类
     */
    public void deleteRule(RuleQo ruleQo);

    /**
     * 查询所有规则
     * @return 规则
     */
    List<RuleCollection> findAll();

    /**
     * 查询所有规则
     * @return 规则
     */
    List<Rule> findRules();

    List<RuleCollection> findByName(String name);

    CustomPage<RuleCollection> findSearch(Map searchMap, int page, int size);

    List<Rule> findAllByTechnologyIdIn(List<String> technologyIds);
}
