package com.zjty.project.state.server.controller;

import com.zjty.project.state.base.exception.MyException;
import com.zjty.project.state.base.response.ResponseCode;
import com.zjty.project.state.base.response.ServerResponse;
import com.zjty.project.state.server.pojo.project.Hardware;
import com.zjty.project.state.server.service.HardwareService;
import com.zjty.project.state.utils.BaseRequest;
import com.zjty.project.state.utils.ExceptionMessage;
import com.zjty.project.state.utils.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * @program: demo
 * @description:
 * @author: LiuJie
 * @create: 2020-02-13 16:04
 **/
@Api(description = "HardwareController项目相关硬件产品接口")
@RestController
@RequestMapping("/hardware")
public class HardwareController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private HardwareService hardwareService;


    @ApiOperation(value = "项目产品清单分页查询", notes = "项目产品清单分页查询")
    @RequestMapping(value = "/search", method = RequestMethod.POST)
    public ServerResponse search(@RequestBody BaseRequest<Hardware> baseRequest){
        try {
            Hardware hardware = baseRequest.getT();
            if (hardware!=null){
                Integer projectId = hardware.getProjectId();
                if (projectId!=null){
                    PageResult<Hardware> pageResult= hardwareService.search(baseRequest);
                    return ServerResponse.success(pageResult);
                }else {
                    throw new MyException(ResponseCode.PROJECT_ID_IS_NULL);
                }
            }else {
                throw new MyException(ResponseCode.PROJECT_ID_IS_NULL);
            }
        }catch (MyException myException) {
            throw myException;
        } catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("项目产品清单分页查询失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }
    }


}
