package com.zjty.project.state.server.controller;

import com.zjty.project.state.base.exception.MyException;
import com.zjty.project.state.base.response.ResponseCode;
import com.zjty.project.state.base.response.ServerResponse;
import com.zjty.project.state.server.pojo.History;
import com.zjty.project.state.server.service.HistoryService;
import com.zjty.project.state.utils.BaseRequest;
import com.zjty.project.state.utils.ExceptionMessage;
import com.zjty.project.state.utils.PageResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

/**
 * <h4>Description : demo</h4>
 *
 * @author : M@tr!x [xhyrzldf@foxmail.com]
 * @Date : 2020-02-27 13:54
 */
@Api(tags = "HistoryController操作历史接口")
@RestController
@RequestMapping("/history")
public class HistoryController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final HistoryService historyService;

    @Autowired
    public HistoryController(HistoryService historyService) {
        this.historyService = historyService;
    }

    @ApiOperation(value = "分页查询项目操作历史", notes = "分页查询项目操作历史")
    @RequestMapping(value = "/search", method = RequestMethod.POST)
    public ServerResponse search(@RequestBody BaseRequest<History> baseRequest){
        try {
            History history = baseRequest.getT();
            if (history!=null){
                Integer projectId = history.getProjectId();
                if (projectId!=null){
                    PageResult<History> pageResult= historyService.search(baseRequest);
                    return ServerResponse.success(pageResult);
                }else {
                    throw new MyException(ResponseCode.PROJECT_ID_IS_NULL);
                }
            }else {
                throw new MyException(ResponseCode.PROJECT_ID_IS_NULL);
            }
        }catch (MyException myException) {
            throw myException;
        } catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("项目分页查询失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }
    }

}
