package com.zjty.project.state.server.controller;

import com.zjty.project.state.base.response.ServerResponse;
import com.zjty.project.state.server.service.GroupConfigService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

/**
 * @program: demo
 * @description:
 * @author: LiuJie
 * @create: 2020-02-13 16:04
 **/
@Api(description = "ImportController接口")
@RestController
@RequestMapping("/import")
public class ImportController {
    @Autowired
    private GroupConfigService groupConfigService;


    //导入
    @ApiOperation(value = "文件导入", notes = "文件导入，导入Excel表格文件")
    @RequestMapping(value = "/upload", method = RequestMethod.POST)
    public ServerResponse<Map<String, Object>> importExcel(@RequestParam("file") MultipartFile file) throws IOException, Exception{
        Map<String, Object> map = new HashMap<String, Object>();
        try {
            map = groupConfigService.importExcel(file);

        } catch (Exception e) {
            map.put("status",-1);
            map.put("data", "导入异常");
        }
        return ServerResponse.success(map);

    }

    @ApiOperation(value = "hello", notes = "hellohello")
    @RequestMapping(value = "/hello", method = RequestMethod.GET)
    public ServerResponse<String> importExcel(){
        return ServerResponse.success("成功了，666");
    }

}
