package com.zjty.project.state.server.controller;

import com.zjty.project.state.base.response.ServerResponse;
import com.zjty.project.state.server.pojo.log.LogRequest;
import com.zjty.project.state.server.service.LogService;
import com.zjty.project.state.utils.BaseRequest;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "LogController日志接口")
@RestController
@RequestMapping("/log")
public class LogController {
    @Autowired
    private LogService logService;
    @ApiOperation(value = "分页查询日志",notes = "根据起始时间、操作人、页码、每页条数查询")
    @PostMapping("/list")
    public ServerResponse listLog(@RequestBody BaseRequest<LogRequest> baseRequest){
        return logService.listLog(baseRequest);
    }
}
