package com.zjty.project.state.server.controller;

import com.zjty.project.state.base.exception.MyException;
import com.zjty.project.state.base.response.ResponseCode;
import com.zjty.project.state.base.response.ServerResponse;
import com.zjty.project.state.server.pojo.Unit;
import com.zjty.project.state.server.pojo.properties.Properties;
import com.zjty.project.state.server.pojo.user.User;
import com.zjty.project.state.server.pojo.user.UserLogin;
import com.zjty.project.state.server.service.RoleService;
import com.zjty.project.state.server.service.UnitService;
import com.zjty.project.state.server.service.UserService;
import com.zjty.project.state.utils.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

/**
 * @program: demo
 * @description:
 * @author: LiuJie
 * @create: 2020-02-13 16:04
 **/
@Api(description = "UserController用户接口")
@RestController
@RequestMapping("/user")
public class UserController {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private UserService userService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private UnitService unitService;

    @ApiOperation(value = "新建用户", notes = "新建用户，同时选着该用户所属角色和单位")
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ServerResponse<String> add(@RequestBody User user){
        try {
            String md5 = MD5Utils.getMD5String("qwer1234");
            user.setPassword(md5);
            userService.add(user);
        }catch (MyException myException) {
            throw myException;
        } catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("新建用户失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }
        return ServerResponse.success("新建用户成功。");
    }

    @ApiOperation(value = "新增用户时，添加照片", notes = "新增用户时，添加照片")
    @RequestMapping(value = "/getPath", method = RequestMethod.POST)
    public ServerResponse getPath(@RequestParam("file") MultipartFile multipartFile) {
        try {
            String path = userService.getPath(multipartFile);
            return ServerResponse.success(path);
        } catch (MyException myException) {
            throw myException;
        }catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("新增用户时，添加照片失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }

    }




    @ApiOperation(value = "用户分页查询", notes = "用户分页查询：根据用户名、角色、单位查询用户列表")
    @RequestMapping(value = "/search", method = RequestMethod.POST)
    public ServerResponse<PageResult<User>> search(@RequestBody BaseRequest<User> baseRequest){
        try {
            PageResult<User> pageResult= userService.search(baseRequest);
            return ServerResponse.success(pageResult);
        }catch (MyException myException) {
            throw myException;
        } catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("用户分页查询失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }
    }


    @ApiOperation(value = "用户修改密码", notes = "用户修改密码")
    @RequestMapping(value = "/updatePassword", method = RequestMethod.POST)
    public ServerResponse<String> updatePassword() throws Exception{
        try {

        }catch (MyException myException) {
            throw myException;
        } catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("用户修改密码失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }
        return ServerResponse.success("用户修改密码成功。");
    }

    @ApiOperation(value = "用户登录", notes = "用户登录")
    @RequestMapping(value = "/login", method = RequestMethod.POST)
//    public ServerResponse login(@RequestBody User user){
    public ServerResponse login(@RequestBody UserLogin user1) throws Exception{
        try {
            String userName = user1.getUserName();
            String password = MD5Utils.getMD5String(user1.getPassword());
            if (userName==null|| password==null){
                throw new MyException(ResponseCode.USER_OR_PASSWORD_IS_NULL);
            }else {
                User user = userService.login(user1.getUserName());
                if (user==null){
                    throw new MyException(ResponseCode.PASSWORD_ERROR);
                }else {
                    if (Properties.NUM_1.equals(user.getDeleted())){
                        throw new MyException(ResponseCode.USER_IS_DELETED);
                    }else {
                        String pass = user.getPassword();
                        user.setPassword(null);
                        if (pass.equals(password)){
                            Unit unit = unitService.findById(user.getUnitId());
                            if(unit.getType()==1){
                                user.setType(1);
                                user.setSessionId(LoginedUserPool.put(user));
                                return ServerResponse.success(user);
                            }else if (unit.getType()==2){
                                user.setType(2);
                                user.setSessionId(LoginedUserPool.put(user));
                                return ServerResponse.success(user);
                            }else {
                                throw new MyException(ResponseCode.UN_POWER);
                            }
                        }else {
                            throw new MyException(ResponseCode.PASSWORD_ERROR);
                        }
                    }
                }
            }
        }catch (MyException myException) {
            throw myException;
        } catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("用户修改密码失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }
    }

    @ApiOperation(value = "上传人员照片", notes = "上传人员照片")
    @RequestMapping(value = "/upload/{id}", method = RequestMethod.POST)
    public ServerResponse upload(@PathVariable("id")Integer id, @RequestParam("file") MultipartFile multipartFile) {
        try {
            userService.upload(id,multipartFile);
            return ServerResponse.success(ResponseCode.OK);
        } catch (MyException myException) {
            throw myException;
        }catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("上传人员照片失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }

    }


    @ApiOperation(value = "用户信息修改", notes = "用户信息修改")
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public ServerResponse update(@RequestBody User user) {
        try {
            userService.update(user);
            return ServerResponse.success(ResponseCode.OK);
        } catch (MyException myException) {
            throw myException;
        }catch (Exception e) {
            String info = ExceptionMessage.getStackTraceInfo(e);
            logger.error("用户信息修改失败:{}",info);
            throw new MyException(ResponseCode.SERVER_ERROR);
        }

    }






}
