package com.zjty.project.state.server.dao;

import com.zjty.project.state.server.pojo.Produce;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.List;

public interface ProduceDao extends JpaRepository<Produce,Integer>,JpaSpecificationExecutor {
    List<Produce> findAllByStatus(Integer status);

    @Query("select p from Produce p where p.id in :list")
    List<Produce> findProduct(@Param(value = "list") List<Integer> list);

    List<Produce> findAllByFormAndStatus(Integer form, Integer status);

    List<Produce> findAllByTypeAndStatus(Integer type, Integer status);
}
