package com.zjty.project.state.server.pojo;


import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;
import java.util.List;


//里程碑表
@Entity
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Goal {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private Integer id;

    /**
     * 里程碑名称
     */
    @ApiModelProperty("里程碑名称")
    private String name;
    @ApiModelProperty("里程碑类型1:需求确认2:初验3：终验")
    private Integer type;

    /**
     * 计划id  plan_id
     */
    @Transient
    @ApiModelProperty("里程碑所在计划Id")
    private Integer planId;

    @ApiModelProperty("里程碑所属项目Id")
    private Integer projectId;

    /**
     * 开始时间
     */
    @ApiModelProperty("开始时间")
    private Date startTime;

    /**
     * 结束时间
     */
    @ApiModelProperty("结束时间")
    private Date endTime;

    /**
     * 完成该里程碑意味的软替任务进度（百分比）
     */
    @Transient
    @ApiModelProperty("完成该里程碑意味的软替任务进度（百分比）")
    private Integer process;

    /**
     * 0：待提交 1：待审核 2：通过
     */
    @Transient
    @ApiModelProperty("里程碑状态 0：待提交 1：待审核 2：通过")
    private Integer state;

    /**
     * 是否被删除(0:删除 1：未删除)
     */
    @Transient
    @ApiModelProperty("是否被删除 0:删除 1：未删除")
    private Integer deleted = 1;

    /**
     * 备注
     */
    @ApiModelProperty("备注")
    private String des;

    /*
    数据存放，不生成字段
     */
    /**
     * 参与人信息
     */
    @Transient
    private List<PlanRole> planRoles;

    /**
     * 文件信息
     */
    @Transient
    private List<File> files;
}
