package com.zjty.project.state.server.pojo;

import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.List;

//微服务表
@Entity
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MicroServer {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @ApiModelProperty("主键")
    private int id;

    /**
     * 微服务名称
     */
    private String name;
    /**
     * 功能描述
     */
    private String des;

    /**
     * 为服务路径
     */
    private String url;
    /**
     * 首页地址，没有页面的可为空
     */
    private String page;
    /**
     * 是否被管理员添加
     */
    private boolean added;

    @Transient
    private List<MicroServerInterface> microServerInterfaceList;
}
