package com.zjty.project.state.server.service;

import com.github.wenhao.jpa.Specifications;
import com.zjty.project.state.server.dao.FileDao;
import com.zjty.project.state.server.pojo.File;
import com.zjty.project.state.server.pojo.History;
import com.zjty.project.state.server.pojo.Produce;
import com.zjty.project.state.server.pojo.user.User;
import com.zjty.project.state.utils.BaseRequest;
import com.zjty.project.state.utils.ExceptionMessage;
import com.zjty.project.state.utils.PageResult;
import com.zjty.project.state.utils.UUIDUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Date;
import java.util.List;
import java.util.Optional;

/**
 * <h4>Description : 文件管理</h4>
 *
 * @author : czq
 * @Date : 2020-02-27 11:22
 */
@Service
public class FileService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value("${upload.location}")
    private String uploadPath;
    @Value("${server.port}")
    private String port;
    @Value("${host.ip}")
    private String localHost;

    private final FileDao fileDao;
    @Autowired
    public FileService(FileDao fileDao) {
        this.fileDao = fileDao;
    }

    @Autowired
    private HistoryService historyService;


    /**
     * 文件上传
     * @return 文件地址
     */
//    public File uploadFile(MultipartHttpServletRequest request, File file) {
//        request.getFile("");
//        return null;
//    }

    /**
     * 文件删除
     *  fileId 文件id
     * @return 成功
     */
//    @Transactional
//    public ServerResponse deletaFile(Integer fileId) {
//        File file = fileDao.getOne(fileId);
//        file.setDeleted(true);
//        return null;
//    }

//    public ServerResponse findFile(File file, Integer page,Integer size) {
//        Specification<File> spec = Specifications.<File>and()
//                .eq(file.getProjectId()!=null,"projectId",file.getProjectId())
//                .eq(file.getUserId()!=null,"userId",file.getUserId())
//                .eq(file.getSoftId()!=null,"softId",file.getSoftId())
//                .eq(file.getHardId()!=null,"hardId",file.getHardId())
//                .eq(file.getGoalId()!=null,"goalId",file.getGoalId())
//                .eq("deleted",1)
//                .build();
//        Pageable pageable = PageRequest.of(page-1, size, Sort.Direction.DESC, "id");
//        long count = fileDao.count(spec);
//        List<File> fileList =fileDao.findAll(spec, pageable).getContent();
//        return ServerResponse.success(new PageResult<>(page,size,count,fileList));//new ListResponse<>(count,fileList));
//    }

    public void creatAll(List<File> files, Integer goalId,Integer projectId) {
        if (files!=null&&files.size()>0&&goalId!=null&&projectId!=null){
            for (File file:files){
                file.setProjectId(projectId);
                file.setGoalId(goalId);
                file.setCreateTime(new Date());
                create(file);
            }
        }

    }

    @Transactional(rollbackFor = Exception.class)
    public void create(File file) {
        fileDao.save(file);
    }

    public PageResult<File> search(BaseRequest<File> baseRequest) {
        File File = baseRequest.getT();
        Integer projectId = File.getProjectId();
        Specification<Produce> specifications = Specifications.<Produce>and()
                .eq( "projectId",projectId)
                .build();
        Integer page = baseRequest.getPage();
        Integer pageSize = baseRequest.getPageSize();
        if (page==null || page<=0){
            page = 1;
        }
        if (pageSize==null || pageSize<=0){
            pageSize = 10;
        }
        Pageable pageable = PageRequest.of(page-1, pageSize, Sort.Direction.DESC, "id");
        Long count = fileDao.count(specifications);
        List<File> files = fileDao.findAll(specifications,pageable).getContent();
        return new PageResult<>(page,pageSize,count,files);

    }

    public Boolean getProcess(Integer goalId) {
//        Boolean flag = true;
//        Map<String, Integer> map = new HashMap<>();
        List<File> fileList = fileDao.findAllByGoalId(goalId);
        for (File f:fileList){
            Integer status = f.getStatus();
            if (status.equals(-1)){
//                flag = false;
                return false;
            }
        }
        return true;
    }

    @Transactional(rollbackFor = Exception.class)
    public void upload(Integer fileId,MultipartFile multipartFile,User user) {
        java.io.File realPathFile = new java.io.File(uploadPath);
        if (!realPathFile.exists()) {
            realPathFile.mkdirs();
        }
        File file = findById(fileId);
        if (file!=null){
            if (multipartFile != null ) {
                logger.info("项目文件不为空");
                if (!multipartFile.isEmpty()) {
                    String name = multipartFile.getOriginalFilename();
                    String[] split = StringUtils.split(name, ".");
                    String fileType = split[split.length - 1];
                    String uuidFileName = UUIDUtils.getUUIDFileName(multipartFile.getOriginalFilename()) +"."+fileType;
                    try {
                        InputStream inputStream = multipartFile.getInputStream();
                        Files.copy(inputStream, Paths.get(uploadPath, uuidFileName), StandardCopyOption.REPLACE_EXISTING);
                        inputStream.close();
                        String photo = "http://" + localHost + ":" + port + "/" + uploadPath + uuidFileName;
                        file.setPath(photo);
                        file.setStatus(1);
                        file.setUploadTime(new Date());
                        file.setUserId(user.getId());
                        file.setUserName(user.getUserName());
                        fileDao.saveAndFlush(file);
                        History history = new History(null,new Date(),user.getId(),user.getName(),"上传项目文件。",file.getProjectId());
                        historyService.addHistory(history);
                    } catch (IOException e) {
                        String info = ExceptionMessage.getStackTraceInfo(e);
                        logger.error("项目文件保存失败:" + info);
                    }
                }
            } else {
                logger.error("项目文件为空");
            }
        }

    }

    public File findById(Integer fileId) {
        if (fileId==null){
            return null;
        }
        Optional<File> optional = fileDao.findById(fileId);
        return optional.isPresent()?optional.get():null;
    }
}
