package com.zjty.project.state.server.service;

import com.zjty.project.state.server.dao.ReplyDao;
import com.zjty.project.state.server.pojo.complain.Reply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

/**
 * @program: state
 * @description:
 * @author: LiuJie
 * @create: 2020-03-04 10:48
 **/
@Service
public class ReplyService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ReplyDao replyDao;

    @Transactional(rollbackFor = Exception.class)
    public void add(Reply reply) {
        replyDao.save(reply);
    }

    public List<Reply> findByComplainId(Integer complainId) {
        List<Reply> list = replyDao.findAllByComplainId(complainId);
        Comparator comparator = getComparator();
        Collections.sort(list,(e1, e2) -> comparator.compare(e1,e2) );
        return list;
    }

    private Comparator getComparator() {
        return new Comparator<Reply>() {
            @Override
            public int compare(Reply r1, Reply r2) {
                Date r1Time = r1.getTime();
                Date r2Time = r2.getTime();
                return -r1Time.compareTo(r2Time);
            }
        };
    }
}
