package com.zjty.project.state.server.service.microServerHeartbitInit;//package com.zjty.server.service.microServerHeartbitInit;
//
//import com.zjty.server.pojo.MicroServer;
//import org.springframework.scheduling.annotation.Scheduled;
//
//import java.util.LinkedHashMap;
//import java.util.List;
//import java.util.Map;
//
///**
// * 内存中维护的微服务列表
// *      系统启动时初始化列表：默认无心跳，心跳延迟次数0，存活状态不存活
// *      定时任务，30秒检查一次是否有心跳：如果没有心跳延迟次数加1，延迟次数大于等于3时将状态改为不存活
// *      客户端发送心跳：将状态改为有心跳，延迟次数清零，状态设为存活
// *
// *      新微服务注册：加入列表，默认无心跳，心跳延迟次数0，存活状态不存活
// */
//public class MicroServerEntityList {
//    /**
//     * 没有心跳次数累加值的上限，达到此上限时设置微服务状态为死亡
//     */
//    public static final int delayHeartBitNumber = 3;
//    //@Autowired
//    private static Map<Integer,MicroServerHeartbitEntity> microServerHeartbitEntityMap;
//
//    protected void initmicroServerHeartbitEntityList(List<MicroServer> all){
//        microServerHeartbitEntityMap = new LinkedHashMap<>();
//        for(MicroServer microServer:all){
//            microServerHeartbitEntityMap.put(microServer.getId(),new MicroServerHeartbitEntity(microServer,false,0,false));
//        }
//    }
//
//    @Scheduled(cron = "0,30 * * * * ? ")
//    private void heartBitSchedule(){
//        for (Map.Entry<Integer,MicroServerHeartbitEntity> entry: microServerHeartbitEntityMap.entrySet()) {
//            MicroServerHeartbitEntity entity = entry.getValue();
//            if(!entity.isHaveHeartBit()){
//                entity.setDelayHeartBitNumber(entity.getDelayHeartBitNumber()+1);
//                if(entity.getDelayHeartBitNumber()>=delayHeartBitNumber){
//                    entity.setAlive(false);
//                }
//            }
//        }
//    }
//
//    public static boolean heartBit(MicroServer microServer){
//        MicroServerHeartbitEntity microServerHeartbitEntity = microServerHeartbitEntityMap.get(microServer.getId());
//        microServerHeartbitEntity.setHaveHeartBit(true);
//        microServerHeartbitEntity.setDelayHeartBitNumber(0);
//        microServerHeartbitEntity.setAlive(true);
//        if(microServerHeartbitEntity.getMicroServer().getName().equals(microServer.getName())) {
//            return true;
//        }else {
//            return false;
//        }
//    }
//
//    /**
//     * ？服务下线后，定时检查要不要排除这个实例？
//     * @param microServer
//     */
//    public static void offLine(MicroServer microServer) {
//        microServerHeartbitEntityMap.get(microServer.getId()).setAlive(false);
//    }
//
//    /**
//     * 新的微服务注册时，添加到静态list中
//     */
//    public static void addMicroServer(MicroServer microServer){
//        microServerHeartbitEntityMap.put(microServer.getId(),new MicroServerHeartbitEntity(microServer,false,0,false));
//    }
//
//    /**
//     * 列表展示所有微服务
//     */
//    public static Map<Integer, MicroServerHeartbitEntity> getList(){
//        return microServerHeartbitEntityMap;
//    }
//}
