package com.zjty.project.state.thread.task;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

/**
 * @program: bserver-parent
 * @description: ScheduledService
 * @author: LiuJie
 * @create: 2019-05-20 15:36
 **/

@Slf4j
@Component
public class ScheduledService {

    @Autowired
    private AsyncTask asyncTask;

    /** 
    * @Description: 每隔30秒，轮训消除一次未消除的报警消息
    * @Param:  
    * @return:  
    * @Author: LiuJie 
    * @Date: 2019/5/31 
    */
    @Scheduled(fixedRate = 1000 * 30)
    public void removeMessage() {
    }

    /**
     * fixedDelay：定义一个按一定频率执行的定时任务，
     * 与上面不同的是，改属性可以配合initialDelay， 定义该任务延迟执行时间。
     */
//    @Scheduled(fixedDelay = 1000,initialDelay=5000)
    public void scheduled2() {
        log.info("=====>>>>>fixedDelay{}",System.currentTimeMillis());
    }


//    @Scheduled(fixedDelay = 1000,initialDelay=5000)
//    public void webSocketServer() throws IOException {
//        webSocketServer.sendMessage("webSocketServer");
//    }
    /** 
    * @Description: 每天23时，55分执行一次,进行生成今日自检报告
    * @Param:
    * @return:  
    * @Author: LiuJie 
    * @Date: 2019/10/12 
    */
    @Scheduled(cron = "0 55 23 * * *")
    public void selfChecking() throws Exception {
    }

    /**
     * @Description: 每天23时，55分执行一次,进行统计分析报告
     * @Param:
     * @return:
     * @Author: LiuJie
     * @Date: 2019/10/12
     */
    @Scheduled(cron = "0 55 23 * * *")
    public void analyse() throws Exception {
    }


    /**
     * cron：通过表达式来配置任务执行时间
     *
     * 一个cron表达式有至少6个（也可能7个）有空格分隔的时间元素。按顺序依次为：
     秒（0~59）
     分钟（0~59）
     3 小时（0~23）
     4 天（0~31）
     5 月（0~11）
     6 星期（1~7 1=SUN 或 SUN，MON，TUE，WED，THU，FRI，SAT）
     年份（1970－2099）
     其中每个元素可以是一个值(如6),一个连续区间(9-12),一个间隔时间(8-18/4)(/表示每隔4小时),一个列表(1,3,5),通配符。由于”月份中的日期”和”星期中的日期”这两个元素互斥的,必须要对其中一个设置。配置实例：

     每隔5秒执行一次：/5 * ?
     每隔1分钟执行一次：0 /1 ?
     0 0 10,14,16 ? 每天上午10点，下午2点，4点
     0 0/30 9-17 ? 朝九晚五工作时间内每半小时
     0 0 12 ? * WED 表示每个星期三中午12点
     “0 0 12 ?” 每天中午12点触发
     “0 15 10 ? “ 每天上午10:15触发
     “0 15 10 ?” 每天上午10:15触发
     “0 15 10 ? *” 每天上午10:15触发
     “0 15 10 ? 2005” 2005年的每天上午10:15触发
     “0 14 * ?” 在每天下午2点到下午2:59期间的每1分钟触发
     “0 0/5 14 ?” 在每天下午2点到下午2:55期间的每5分钟触发
     “0 0/5 14,18 ?” 在每天下午2点到2:55期间和下午6点到6:55期间的每5分钟触发
     “0 0-5 14 ?” 在每天下午2点到下午2:05期间的每1分钟触发
     “0 10,44 14 ? 3 WED” 每年三月的星期三的下午2:10和2:44触发
     “0 15 10 ? * MON-FRI” 周一至周五的上午10:15触发
     “0 15 10 15 * ?” 每月15日上午10:15触发
     “0 15 10 L * ?” 每月最后一日的上午10:15触发
     “0 15 10 ? * 6L” 每月的最后一个星期五上午10:15触发
     “0 15 10 ? * 6L 2002-2005” 2002年至2005年的每月的最后一个星期五上午10:15触发
     “0 15 10 ? * 6#3” 每月的第三个星期五上午10:15触发
     */
//    @Scheduled(cron = "0/5 * * * * *")
//    public void scheduled(){
//        log.info("=====>>>>>使用cron  {}",System.currentTimeMillis());
//    }
}