import { createRouter, createWebHistory, createWebHashHistory } from "vue-router"
import dataCenter from "./dataCenter"
import navigation from "./navigation";
import {
    DataCenterRouter
} from "./dataCenter"

/**
 * 基础路由
 */
export enum BaseRouteRouter {
    LOGIN = "/login",
    SSO = '/sso',
    NOT_FIND="/404"

}

export const routes: any[] = [
    ...dataCenter,
    {
        path: "/",
        redirect: DataCenterRouter.DATA_MAP,
    },
    {
        path: "/index",
        redirect: DataCenterRouter.DATA_MAP,
    },
    {
        path: BaseRouteRouter.LOGIN,
        meta: {
            label: "登录",
        },
        name: "login",
        component: () => import("@/views/login/index.vue")
    },
    {
        path: BaseRouteRouter.SSO,
        meta: {
            label: "卫士通",
        },
        name: "sso",
        component: () => import("@/views/sso/index.vue")
    },
    {
        path: "/:pathMatch(.*)*",
        meta: {
            label: "404",
        },
        name: "404",
        component: () => import("@/views/404/index.vue")
    },
]

const router = createRouter({
    history: createWebHashHistory(),
    routes,
    scrollBehavior(to, from, savedPosition) {
        return { top: 0 }
    },
})

export default navigation(router);