import Axios from "axios"
import responseMiddle from "./responseMiddle"

const ENV_PARAMS = import.meta.env; // 这是Vite官方指导获取环境变量的方式
/**
 * 判断是生产环境还是本地环境
 * 生成环境使用 /api 前缀
 * 本地环境使用 /mock 前缀
 */
// export const getBaseUrl = (): string => {
//     const { DEV, VITE_DEV_API, VITE_PRD_API } = ENV_PARAMS;

//     return DEV ? VITE_DEV_API : VITE_PRD_API;
// };
// console.log(getBaseUrl(),'getBaseUrl()');

const axios = Axios.create({
    // baseURL: getBaseUrl(),
    baseURL: window.baseURL.devUrl,
    timeout: 1000,
});


// 添加请求拦截器
axios.interceptors.request.use(function (config) {
    // 在发送请求之前做些什么
    return config;
}, function (error) {
    // 对请求错误做些什么
    return Promise.reject(error);
});

// 添加响应拦截器
axios.interceptors.response.use(function (response) {
    // 对响应数据做点什么
    return responseMiddle(response);
}, function (error) {
    // 对响应错误做点什么
    return Promise.reject(error);
});

export default axios;