import { Router } from "vue-router"
import { TOKEN_KEY } from "@/utils/enum/token.ts";
import { BaseRouteRouter } from "./index"
const whiteRoutes = ["/login", "/sso"]

export default (router: Router) => {
    const token = localStorage.getItem(TOKEN_KEY)
    router.beforeEach((to, from, next) => {
        if (whiteRoutes.includes(to.path)) {
            return next()
        }

        if (!token) {
            router.replace(BaseRouteRouter.LOGIN);
        } else {
            next()
        }
    })
    return router
}