import { createRouter, createWebHistory, createWebHashHistory } from "vue-router"
import dataCenter from "./dataCenter"
import navigation from "./navigation";
import {
    DataCenterRouter
} from "./dataCenter"

export const routes: any[] = [
    ...dataCenter,
    {
        path: "/:pathMatch(.*)*",
        redirect: DataCenterRouter.DATA_MAP,
    },
]

const router = createRouter({
    history: createWebHashHistory(),
    routes,
    scrollBehavior(to, from, savedPosition) {
        return { top: 0 }
    },
})

export default navigation(router);