import { createRouter, createWebHistory, createWebHashHistory } from "vue-router"
import dataCenter from "./dataCenter"
import navigation from "./navigation";
import {
    DataCenterRouter
} from "./dataCenter"

/**
 * 基础路由
 */
export enum BaseRouteRouter {
    LOGIN = "/login",
    SSO = '/sso',
    NOT_FIND="/404"

}

export const routes: any[] = [
    ...dataCenter,
    {
        path: BaseRouteRouter.LOGIN,
        meta: {
            label: "登录",
        },
        name: "login",
        component: () => import("@/views/login/index.vue")
    },
    {
        path: BaseRouteRouter.SSO,
        meta: {
            label: "卫士通",
        },
        name: "sso",
        component: () => import("@/views/sso/index.vue")
    },
    {
        path: "/:pathMatch(.*)*",
        redirect: DataCenterRouter.DATA_MAP,
    },
]

const router = createRouter({
    history: createWebHashHistory(),
    routes,
    scrollBehavior(to, from, savedPosition) {
        return { top: 0 }
    },
})

export default navigation(router);