import request from '@/axios'

//单点登录校验
export const getLogin = async () => {
  return request({
    url: "/user/generatorChallenge"
  })
}

/**
 * 登录系统
 * @param {*} challenge  // getLogin 接口返回的
 * @param {*} ticket  // webSokect 成功后返回的
 * @param {*} type  // 0|1   平台端|企业端
 * @param {*} flag  // false   卫士通登录
 * @returns 
 */
export const postLogin = async (challenge:string, ticket:string) => {
  return request({
    url: "/sso",
    method: "post",
    data: {
      challenge,
      ticket,
      type: 0,
      flag: false
    }
  })
}