/**
 * 数据中心模块——路由
 */
export enum DataCenterRouter {
    DATA_CENTER = "/dataCenter",
    DATA_MAP = "/dataCenter/map",
    DATA_INDUSTRIAL = "/dataCenter/industrial",
    DATA_ARMY = "/dataCenter/army",
    INNOVATION="/dataCenter/innovation",
    ConctructSystem="/dataCenter/conctructSystem"
}

export default [
    {
        path: DataCenterRouter.DATA_CENTER,
        name: "DataCenter",
        component: () => import("@/views/dataCenter/index.vue"),
        redirect: DataCenterRouter.DATA_MAP,
        children: [
            {
                path: DataCenterRouter.DATA_MAP,
                meta: {
                    label: "数据中心",
                },
                name: "Map",
                component: () => import("@/views/dataCenter/map/index.vue")
            },
            {
                path: DataCenterRouter.DATA_INDUSTRIAL,
                name: "Industrial",
                meta: {
                    person: {
                        path: DataCenterRouter.DATA_CENTER,
                        name: "DataCenter",
                        label: "数据中心",
                    },
                    label: "产业融合发展",
                },
                component: () => import("@/views/dataCenter/industrial/index.vue")
            },
            {
                path: DataCenterRouter.DATA_ARMY,
                name: "Army",
                meta: {
                    person: {
                        path: DataCenterRouter.DATA_CENTER,
                        name: "DataCenter",
                        label: "数据中心",
                    },
                    label: "服务强军兴军",
                },
                component: () => import("@/views/dataCenter/army/index.vue")
            },
            {
                path: DataCenterRouter.INNOVATION,
                name: "Innovation",
                meta: {
                    person: {
                        path: DataCenterRouter.DATA_CENTER,
                        name: "DataCenter",
                        label: "数据中心",
                    },
                    label: "军民协同创新",
                },
                component: () => import("@/views/dataCenter/innovation/index.vue")
            },
            {
                path: DataCenterRouter.ConctructSystem,
                name: "ConctructSystem",
                meta: {
                    person: {
                        path: DataCenterRouter.DATA_CENTER,
                        name: "DataCenter",
                        label: "数据中心",
                    },
                    label: "五大建设体系",
                },
                component: () => import("@/views/dataCenter/ConctructSystem/index.vue")
            }
        ],

    },

]