package com.example.demo.controller;

import entity.UserEntity;
import mapper.UserMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.xml.transform.Result;

/**
 * @author dengdiyi
 */
@RestController
@RequestMapping(value = "/user")
public class MyController {
    @Autowired
    private UserMapper userMapper;

    @GetMapping("/{id}")
    public UserEntity getById(@PathVariable("id") int id){
        return userMapper.findById(id);
    }

    @PostMapping("/add/{id}/{name}/{password}/{phone}")
    public void insertUser(@PathVariable("id") int id,@PathVariable("name") String name,@PathVariable("password") String password,@PathVariable("phone") String phone){
        userMapper.insertUser(id,name,password,phone);
    }

    @PatchMapping("/update/{id}/{name}/{password}/{phone}")
    public void updateUser(@PathVariable("id") int id,@PathVariable("name") String name,@PathVariable("password") String password,@PathVariable("phone") String phone) {
        UserEntity userEntity = new UserEntity();
        userEntity.setUserId(id);
        userEntity.setUserName(name);
        userEntity.setUserPassword(password);
        userEntity.setUserPhoneNum(phone);
        userMapper.updateUser(userEntity);
    }

    @DeleteMapping("/delete/{id}")
    public void deleteUser(@PathVariable("id") int id){
        userMapper.delectById(id);
    }

}
