package com.example.demo;

import entity.UserEntity;
import mapper.UserMapper;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;

@SpringBootTest
public class SelectTest {
    @Autowired
    private UserMapper userMapper;

    @Test
    public void testSelect(){
        UserEntity userEntity = userMapper.findById(1);
        String name = userEntity.getUserName();
        String phone = userEntity.getUserPhoneNum();
        System.out.println(name+phone);
    }

    @Test
    public void testInsert(){
        userMapper.insertUser(2,"cxt","123456","13888888888");
        UserEntity userEntity = userMapper.findById(2);
        String name = userEntity.getUserName();
        String phone = userEntity.getUserPhoneNum();
        System.out.println(name+phone);
    }

    @Test
    public void testUpdate(){
        UserEntity userEntity = userMapper.findById(2);
        userEntity.setUserPhoneNum("13487479228");
        userMapper.updateUser(userEntity);
        UserEntity userEntity2 = userMapper.findById(2);
        String name = userEntity2.getUserName();
        String phone = userEntity2.getUserPhoneNum();
        System.out.println(name+phone);
    }

    @Test
    public void testDelect(){
        userMapper.delectById(2);
        UserEntity userEntity = userMapper.findById(2);
        System.out.println(userEntity);
    }

}
