package com.example.removetolocal.newentity;

import lombok.AllArgsConstructor;
import lombok.Data;
import javax.persistence.*;

import lombok.NoArgsConstructor;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for device_check_bill
 * 装备核查账单
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "device_check_bill")
public class DeviceCheckBill {

	/**
	* 主键id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* 检查组成员1(省A岗)id
	*/
	@Column(name = "userA_id")
	private Integer userAId;
	/**
	* 检查组成员2(省A岗)id
	*/
	@Column(name = "userB_id")
	private Integer userBId;
	/**
	* 核查状态(0:决算待审核,1:决算审核失败,2:决算中,3:决算完成)
	*/
	@Column(name = "check_status")
	private Integer checkStatus;
	/**
	* 核查单位主键id(x作为分隔符)，例如1x2,意为单位id为1和2的装备核查
	*/
	@Column(name = "check_detail")
	private String checkDetail;
	/**
	* 核查标题
	*/
	@Column(name = "check_title")
	private String checkTitle;
	/**
	* 备注
	*/
	@Column(name = "remark")
	private String remark;
	/**
	* 创建用户id
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* 创建时间
	*/
	@Column(name = "create_time")
	@CreatedDate
	private java.util.Date createTime;
	/**
	* 更新用户id
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* 更新时间
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private java.util.Date updateTime;
	/**
	* 删除标记(0:未删除，1:已删除)
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag;
	/**
	* useraid
	*/
	@Column(name = "useraid")
	private Integer useraid;
	/**
	* userbid
	*/
	@Column(name = "userbid")
	private Integer userbid;

}
