package com.example.removetolocal.newentity;

import lombok.AllArgsConstructor;
import lombok.Data;
import javax.persistence.*;

import lombok.NoArgsConstructor;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for device_log
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "device_log")
public class DeviceLog {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private java.util.Date createTime;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag = 0;
	/**
	* deviceId
	*/
	@Column(name = "device_id")
	private Integer deviceId;
	/**
	* fileDetail
	*/
	@Column(name = "file_detail")
	private String fileDetail;
	/**
	* logTime
	*/
	@Column(name = "log_time")
	private java.util.Date logTime;
	/**
	* remark
	*/
	@Column(name = "remark")
	private String remark;
	/**
	* type
	*/
	@Column(name = "type")
	private Integer type = 0;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private java.util.Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;

	@Column(name = "old_id")
	private Integer oldId;

}
