package com.example.removetolocal.newentity;

import lombok.AllArgsConstructor;
import lombok.Data;
import javax.persistence.*;

import lombok.NoArgsConstructor;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for input_output_device
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "input_output_device")
public class InputOutputDevice {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private java.util.Date createTime;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag;
	/**
	* deviceId
	*/
	@Column(name = "device_id")
	private Integer deviceId;
	/**
	* direction
	*/
	@Column(name = "direction")
	private Integer direction;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private java.util.Date updateTime;
	/**
	* isRead
	*/
	@Column(name = "is_read")
	private Integer isRead;
	/**
	* rfidCardId
	*/
	@Column(name = "rfid_card_id")
	private String rfidCardId;
	/**
	* unitId
	*/
	@Column(name = "unit_id")
	private Integer unitId;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;

}
