package com.example.removetolocal.newentity;

import lombok.AllArgsConstructor;
import lombok.Data;
import javax.persistence.*;

import lombok.NoArgsConstructor;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for library_warning_log_detail
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "library_warning_log_detail")
public class LibraryWarningLogDetail {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private java.util.Date createTime;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag;
	/**
	* deviceId
	*/
	@Column(name = "device_id")
	private Integer deviceId;
	/**
	* handleResult
	*/
	@Column(name = "handle_result")
	private String handleResult;
	/**
	* inventoryResults
	*/
	@Column(name = "inventory_results")
	private String inventoryResults;
	/**
	* libraryWarningLogId
	*/
	@Column(name = "library_warning_log_id")
	private Integer libraryWarningLogId;
	/**
	* status
	*/
	@Column(name = "status")
	private Integer status;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private java.util.Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* warningHandle
	*/
	@Column(name = "warning_handle")
	private Integer warningHandle;
	/**
	* point
	*/
	@Column(name = "point")
	private String point;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;

}
