package com.example.removetolocal.newentity;

import lombok.AllArgsConstructor;
import lombok.Data;
import javax.persistence.*;

import lombok.NoArgsConstructor;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for repair_detail
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "repair_detail")
public class RepairDetail {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private java.util.Date createTime;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag;
	/**
	* deviceId
	*/
	@Column(name = "device_id")
	private Integer deviceId;
	/**
	* deviceRepairBillId
	*/
	@Column(name = "device_repair_bill_id")
	private Integer deviceRepairBillId;
	/**
	* locationUnit
	*/
	@Column(name = "location_unit")
	private String locationUnit;
	/**
	* model
	*/
	@Column(name = "model")
	private String model;
	/**
	* name
	*/
	@Column(name = "name")
	private String name;
	/**
	* ownUnit
	*/
	@Column(name = "own_unit")
	private String ownUnit;
	/**
	* remark
	*/
	@Column(name = "remark")
	private String remark;
	/**
	* repairStatus
	*/
	@Column(name = "repair_status")
	private Integer repairStatus;
	/**
	* rfidSurfaceId
	*/
	@Column(name = "rfid_surface_id")
	private String rfidSurfaceId;
	/**
	* seqNumber
	*/
	@Column(name = "seq_number")
	private String seqNumber;
	/**
	* type
	*/
	@Column(name = "type")
	private Integer type;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private java.util.Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* newDeviceDetailId
	*/
	@Column(name = "new_device_detail_id")
	private Integer newDeviceDetailId;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;

}
