package com.example.removetolocal.newentity;

import lombok.AllArgsConstructor;
import lombok.Data;
import javax.persistence.*;

import lombok.NoArgsConstructor;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for scrap_bill
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "scrap_bill")
public class ScrapBill {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private java.util.Date createTime;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag;
	/**
	* docNumber
	*/
	@Column(name = "doc_number")
	private String docNumber;
	/**
	* fileName
	*/
	@Column(name = "file_name")
	private String fileName;
	/**
	* fileUrl
	*/
	@Column(name = "file_url")
	private String fileUrl;
	/**
	* leader
	*/
	@Column(name = "leader")
	private String leader;
	/**
	* manager
	*/
	@Column(name = "manager")
	private String manager;
	/**
	* models
	*/
	@Column(name = "models")
	private String models;
	/**
	* names
	*/
	@Column(name = "names")
	private String names;
	/**
	* repairBillId
	*/
	@Column(name = "repair_bill_id")
	private Integer repairBillId;
	/**
	* scrapDetail
	*/
	@Column(name = "scrap_detail")
	private String scrapDetail;
	/**
	* scrapTime
	*/
	@Column(name = "scrap_time")
	private java.util.Date scrapTime;
	/**
	* scrapUnit
	*/
	@Column(name = "scrap_unit")
	private String scrapUnit;
	/**
	* supervisor
	*/
	@Column(name = "supervisor")
	private String supervisor;
	/**
	* undertaker
	*/
	@Column(name = "undertaker")
	private String undertaker;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private java.util.Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;

}
