package com.example.removetolocal.newentity;

import lombok.AllArgsConstructor;
import lombok.Data;
import javax.persistence.*;

import lombok.NoArgsConstructor;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for storage_bill
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "storage_bill")
public class StorageBill {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* applyNumber
	*/
	@Column(name = "apply_number")
	private String applyNumber;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private java.util.Date createTime;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag = 0;
	/**
	* fileName
	*/
	@Column(name = "file_name")
	private String fileName;
	/**
	* fileUrl
	*/
	@Column(name = "file_url")
	private String fileUrl;
	/**
	* receiveFileName
	*/
	@Column(name = "receive_file_name")
	private String receiveFileName;
	/**
	* receiveFileUrl
	*/
	@Column(name = "receive_file_url")
	private String receiveFileUrl;
	/**
	* receiveUseraId
	*/
	@Column(name = "receive_usera_id")
	private Integer receiveUseraId;
	/**
	* receiveUserbId
	*/
	@Column(name = "receive_userb_id")
	private Integer receiveUserbId;
	/**
	* replayNumber
	*/
	@Column(name = "replay_number")
	private String replayNumber;
	/**
	* sendTime
	*/
	@Column(name = "send_time")
	private java.util.Date sendTime;
	/**
	* sendUnit
	*/
	@Column(name = "send_unit")
	private String sendUnit;
	/**
	* sendUserId
	*/
	@Column(name = "send_user_id")
	private String sendUserId;
	/**
	* storageDetail
	*/
	@Column(name = "storage_detail",columnDefinition="TEXT")
	private String storageDetail;
	/**
	* storageStatus
	*/
	@Column(name = "storage_status")
	private Integer storageStatus;
	/**
	* storagedCount
	*/
	@Column(name = "storaged_count")
	private Integer storagedCount;
	/**
	* storagingCount
	*/
	@Column(name = "storaging_count")
	private Integer storagingCount;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private java.util.Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;

}
