package com.example.removetolocal.newentity;

import lombok.Data;
import javax.persistence.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for user_log
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@SQLDelete(sql = "update user_log set delete_tag = 1 where id = ?")
@Where(clause = "delete_tag = 0")
@Table(name = "user_log")
public class UserLog {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* content
	*/
	@Column(name = "content")
	private String content;
	/**
	* time
	*/
	@Column(name = "time")
	private java.util.Date time;
	/**
	* userId
	*/
	@Column(name = "user_id")
	private Integer userId;

}
