package com.example.removetolocal.newentity;

import lombok.AllArgsConstructor;
import lombok.Data;
import javax.persistence.*;

import lombok.NoArgsConstructor;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for work_handover
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "work_handover")
public class WorkHandover {

	/**
	* workHandoverId
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "work_handover_id")
	private Integer workHandoverId;
	/**
	* commissionWord
	*/
	@Column(name = "commission_word")
	private String commissionWord;
	/**
	* fileLists
	*/
	@Column(name = "file_lists")
	private String fileLists;
	/**
	* handoverUserId
	*/
	@Column(name = "handover_user_id")
	private Integer handoverUserId;
	/**
	* inUserName
	*/
	@Column(name = "in_user_name")
	private String inUserName;
	/**
	* trackingWord
	*/
	@Column(name = "tracking_word")
	private String trackingWord;
	/**
	* turnOverUserId
	*/
	@Column(name = "turn_over_user_id")
	private Integer turnOverUserId;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private Integer createTime;
	/**
	* status
	*/
	@Column(name = "status")
	private Integer status;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private Integer updateTime;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;

}
