package com.example.removetolocal.olddevice.domin;

import lombok.Data;
import javax.persistence.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for dev_record
 * 设备档案
*/
@Data
@Entity
@Table(name = "dev_record")
public class DevRecordEntity {

	/**
	* 主键id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* 主键id
	*/
	@Column(name = "pid")
	private Integer pid;
	/**
	* 列装设备id
	*/
	@Column(name = "catalogId")
	private Integer catalogId;
	/**
	* model
	*/
	@Column(name = "model")
	private String model;
	/**
	* 装备序列号
	*/
	@Column(name = "serNum")
	private String serNum;
	/**
	* 生产序列号
	*/
	@Column(name = "proNum")
	private String proNum;
	/**
	* 默认RFIDEPC区内容
	*/
	@Column(name = "rfid")
	private String rfid;
	/**
	* 所在单位
	*/
	@Column(name = "whereUnit")
	private String whereUnit;
	/**
	* 所属单位
	*/
	@Column(name = "ownUnit")
	private String ownUnit;
	/**
	* 使用状态
	*/
	@Column(name = "useStatus")
	private Integer useStatus;
	/**
	* 生命状态
	*/
	@Column(name = "lifeStatus")
	private Integer lifeStatus;
	/**
	* instorageType
	*/
	@Column(name = "instorageType")
	private Integer instorageType;
	/**
	* 是否苏定
	*/
	@Column(name = "islock")
	private Integer islock;
	/**
	* 创建人
	*/
	@Column(name = "createUser")
	private String createUser;
	/**
	* createTime
	*/
	@Column(name = "createTime")
	private java.util.Date createTime;
	/**
	* updateUser
	*/
	@Column(name = "updateUser")
	private String updateUser;
	/**
	* updateTime
	*/
	@Column(name = "updateTime")
	private java.util.Date updateTime;
	/**
	* 备注
	*/
	@Column(name = "remark")
	private String remark;
	/**
	* 逻辑删除标志
	*/
	@Column(name = "isDel")
	private Integer isDel;
	/**
	* 锁定类型
	*/
	@Column(name = "lockType")
	private Integer lockType;

}
