package com.example.removetolocal.oldentity;

import com.example.removetolocal.newstorage.bto.TaskBto;
import com.example.removetolocal.newuser.domin.User;
import com.example.removetolocal.oldentity.dao.DevTaskoperaterDao;
import com.example.removetolocal.service.UserService;
import com.example.removetolocal.utils.SpringUtils;
import lombok.Data;
import javax.persistence.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;

import java.util.*;
import java.util.stream.Collectors;

import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for dev_taskmain
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "dev_taskmain")
public class DevTaskmain {

	/**
	* 主键id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* 任务类型
	*/
	@Column(name = "type")
	private Integer type;
	/**
	* 业务id
	*/
	@Column(name = "resourceId")
	private Integer resourceId;
	/**
	* 标题
	*/
	@Column(name = "title")
	private String title;
	/**
	* 创建人
	*/
	@Column(name = "creator")
	private String creator;
	/**
	* 创建单位
	*/
	@Column(name = "companyId")
	private String companyId;
	/**
	* 创建时间
	*/
	@Column(name = "createTime")
	private java.util.Date createTime;
	/**
	* 最近一次页面地址
	*/
	@Column(name = "lastUrl")
	private String lastUrl;
	/**
	* 最近一次发起人
	*/
	@Column(name = "lastEditor")
	private String lastEditor;
	/**
	* 最近一次发起单位
	*/
	@Column(name = "lastCompanyId")
	private String lastCompanyId;
	/**
	* 是否办结
	*/
	@Column(name = "isComplete")
	private Integer isComplete;
	/**
	* 是否封存
	*/
	@Column(name = "isSeal")
	private Integer isSeal;
	/**
	* 最后一次操作时间
	*/
	@Column(name = "lastEditTime")
	private java.util.Date lastEditTime;

	public TaskBto parseToTaskBto(){
		DevTaskoperaterDao devTaskoperaterDao = SpringUtils.getBean("devTaskoperaterDao");
		UserService userService = SpringUtils.getBean("userServiceImpl");
		List<DevTaskoperater> devTaskoperaters = Objects.requireNonNull(devTaskoperaterDao).findAllByTaskId(this.id).stream()
				.sorted(Comparator.comparing(DevTaskoperater::getReceiveTime))
				.collect(Collectors.toList());
		TaskBto taskBto = new TaskBto();
		switch (this.type){
			case 1:
				taskBto.setBusinessType(3);
				break;
			case 3:
				taskBto.setBusinessType(5);
				break;
			case 4:
				taskBto.setBusinessType(10);
				break;
			case 5:
				taskBto.setBusinessType(15);
				break;
			case 6:
				taskBto.setBusinessType(14);
				break;
			case 7:
				taskBto.setBusinessType(16);
				break;
			case 9:
				taskBto.setBusinessType(4);
				break;
			case 10:
				taskBto.setBusinessType(6);
				break;
			case 12:
				taskBto.setBusinessType(2);
				break;
			case 18:
				taskBto.setBusinessType(13);
				break;
			case 28:
				taskBto.setBusinessType(21);
				break;
			default:break;
		}
		taskBto.setTitle(this.title);
		taskBto.setNodeIdDetail(".");
		if (this.isComplete==1){
			taskBto.setBillStatus(9999);
		}
		if (this.isSeal==1){
			taskBto.setBillStatus(8888);
		}
		taskBto.setCreateTime(this.createTime);
		taskBto.setUpdateTime(this.getLastEditTime());
		taskBto.setCreateUserId(Objects.requireNonNull(userService).getUserByOldId(this.creator).getUserId());
		if (this.lastEditor!=null) {
			taskBto.setUpdateUserId(userService.getUserByOldId(this.lastEditor).getUserId());
		}
		taskBto.getInvolveUserIdList().add(Objects.requireNonNull(userService).getUserByOldId(this.creator).getUserId());
		taskBto.setCurrentPoint(0);
		boolean isMore = devTaskoperaters.stream().filter(devTaskoperater -> devTaskoperater.getIsDone()==0).count()>1;
		devTaskoperaters.forEach(devTaskoperater -> {
			User user = Objects.requireNonNull(userService).getUserByOldId(devTaskoperater.getReceiver());
			if (devTaskoperater.getIsDone()==1){
				taskBto.getInvolveUserIdList().add(user.getUserId());
				taskBto.setOwnUnit(user.getUnitsId());
				taskBto.setCurrentPoint(taskBto.getCurrentPoint()+1);
			}
			else {
				if (isMore){
					taskBto.getInvolveUserIdList().add(0);
					taskBto.setOwnUnit(user.getUnitsId());
					taskBto.setCurrentPoint(taskBto.getCurrentPoint()+1);
				}
				else {
					taskBto.getInvolveUserIdList().add(user.getUserId());
					taskBto.setOwnUnit(user.getUnitsId());
					taskBto.setCurrentPoint(taskBto.getCurrentPoint()+1);
				}
			}
			if (devTaskoperater.getIsRead()==1){
				taskBto.getUserReadDetailList().add(user.getUserId());
			}
			else {
				if (taskBto.getUserReadDetailList().contains(user.getUserId())) {
					taskBto.getUserReadDetailList().removeAll(new ArrayList<>(Collections.singletonList(user.getUserId())));
				}
			}
		});
		return taskBto;
	}
}
