package com.example.removetolocal.oldentity;

import lombok.Data;
import javax.persistence.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for dev_taskoperater
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "dev_taskoperater")
public class DevTaskoperater {

	/**
	* 主键id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* 任务类型
	*/
	@Column(name = "taskId")
	private Integer taskId;
	/**
	* 页面地址
	*/
	@Column(name = "url")
	private String url;
	/**
	* 创建人
	*/
	@Column(name = "creator")
	private String creator;
	/**
	* 创建单位
	*/
	@Column(name = "companyId")
	private String companyId;
	/**
	* 接收人
	*/
	@Column(name = "receiver")
	private String receiver;
	/**
	* 接收单位
	*/
	@Column(name = "receiveCompanyId")
	private String receiveCompanyId;
	/**
	* 接收时间
	*/
	@Column(name = "receiveTime")
	private java.util.Date receiveTime;
	/**
	* 是否已读 0：未读 1：已读
	*/
	@Column(name = "isRead")
	private Integer isRead;
	/**
	* 阅读时间
	*/
	@Column(name = "readTime")
	private java.util.Date readTime;
	/**
	* 是否已办 0：未办 1：已办
	*/
	@Column(name = "isDone")
	private Integer isDone;
	/**
	* 办理时间
	*/
	@Column(name = "operateTime")
	private java.util.Date operateTime;

}
