package com.example.removetolocal.service.impl;

import com.example.removetolocal.newdevice.dao.DeviceLibraryDao;
import com.example.removetolocal.newrepair.dao.RepairBackBillDao;
import com.example.removetolocal.newrepair.dao.RepairBillDao;
import com.example.removetolocal.newrepair.dao.RepairDetailDao;
import com.example.removetolocal.newrepair.dao.RepairSendBillDao;
import com.example.removetolocal.newrepair.entity.RepairBill;
import com.example.removetolocal.newrepair.entity.RepairSendBill;
import com.example.removetolocal.newstorage.dao.TaskDao;
import com.example.removetolocal.newstorage.dao.TaskLogDao;
import com.example.removetolocal.newuser.dao.UnitsDao;
import com.example.removetolocal.newuser.dao.UserDao;
import com.example.removetolocal.oldentity.DevRepair;
import com.example.removetolocal.oldentity.dao.*;
import com.example.removetolocal.service.RepairService;
import com.example.removetolocal.service.UserService;
import com.example.removetolocal.utils.StringSplitUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Service
public class RepairServiceImpl implements RepairService {

    @Autowired
    RepairBillDao repairBillDao;
    @Autowired
    RepairSendBillDao repairSendBillDao;
    @Autowired
    RepairDetailDao repairDetailDao;
    @Autowired
    RepairBackBillDao repairBackBillDao;
    @Autowired
    DevRepairDao devRepairDao;
    @Autowired
    DevRepairdetailDao devRepairdetailDao;
    @Autowired
    DevRepairReceiveDao devRepairReceiveDao;
    @Autowired
    DevRepairReceivedetailDao devRepairReceivedetailDao;
    @Autowired
    UserService userService;
    @Autowired
    DeviceLibraryDao deviceLibraryDao;
    @Autowired
    DevTaskmainDao devTaskmainDao;
    @Autowired
    TaskDao taskDao;
    @Autowired
    DevTasklogDao devTasklogDao;
    @Autowired
    TaskLogDao taskLogDao;
    @Autowired
    UnitsDao unitsDao;
    @Autowired
    UserDao userDao;
    /**
     * 送修业务转换
     */
    @Override
    public void moveRepair() {
        //转换送修单
        List<DevRepair> devRepairs = devRepairDao.findAll();
        devRepairs.forEach(devRepair -> {
            if (devRepair.getStatus()==4){
                RepairBill repairBill = new RepairBill();
                repairBill.setCreateTime(devRepair.getApplyTime());
                repairBill.setUpdateTime(devRepair.getHandleTime());
                if (!checkcountname(devRepair.getApplyUser())&&(userDao.findByOldCode(devRepair.getApplyUser()) != null || userDao.findByOldId(devRepair.getApplyUser()) != null)) {
                    repairBill.setCreateUserId(userDao.findByOldCode(devRepair.getApplyUser()) == null ? userDao.findByOldId(devRepair.getApplyUser()).getUserId() : userDao.findByOldCode(devRepair.getApplyUser()).getUserId());
                }
                if (devRepair.getHandleConfirmUser()==null||checkcountname(devRepair.getHandleConfirmUser())){
                    repairBill.setUpdateUserId(repairBill.getCreateUserId());
                }
                else if (!checkcountname(devRepair.getHandleConfirmUser())&&(userDao.findByOldCode(devRepair.getHandleConfirmUser()) != null || userDao.findByOldId(devRepair.getHandleConfirmUser()) != null)) {
                    repairBill.setUpdateUserId(userDao.findByOldCode(devRepair.getHandleConfirmUser()) == null ? userDao.findByOldId(devRepair.getHandleConfirmUser()).getUserId() : userDao.findByOldCode(devRepair.getHandleConfirmUser()).getUserId());
                }
                repairBill.setDocNum(devRepair.getDocNo());
                repairBill.setReceiveUnit(userService.getUnitNameByOldId(devRepair.getHandleUnit()));
                repairBill.setSendUnit(userService.getUnitNameByOldId(devRepair.getApplyUnit()));
                repairBill.setRepairStatus(4);
                repairBill.setRepairUsera(userService.getUserNameByOldId(devRepair.getHandleUser()));
                repairBill.setRepairUserb(userService.getUserNameByOldId(devRepair.getHandleConfirmUser()));
                repairBill.setStartUsera(userService.getUserNameByOldId(devRepair.getApplyUser()));
                repairBill.setStartUserb(userService.getUserNameByOldId(devRepair.getApplyConfirmUser()));
                repairBill.setOldId(devRepair.getId());
                RepairBill repairBill1 = repairBillDao.save(repairBill);
                RepairSendBill repairSendBill = new RepairSendBill();
                repairSendBill.setCreateUserId(repairBill1.getCreateUserId());
                repairSendBill.setCreateTime(repairBill1.getCreateTime());
                repairSendBill.setUpdateTime(repairBill1.getUpdateTime());
                repairSendBill.setUpdateUserId(repairBill1.getUpdateUserId());
                repairSendBill.setDeviceRepairBillId(repairBill1.getId());
                repairSendBill.setReceiveCount(devRepair.getTotal());
                repairSendBill.setSendedCount(devRepair.getTotal());
                repairSendBill.setSendingCount(devRepair.getTotal());
                repairSendBill.setReceiveTime(devRepair.getHandleTime());
                repairSendBill.setReceiveUnit(repairBill1.getReceiveUnit());
                repairSendBill.setRepairStatus(5);
                repairSendBill.setRepairDeviceCheckResult("0x0");
                repairSendBill.setRepairReciveCheckResult("0x0");
                List<Integer> deviceIds = new ArrayList<>();
                StringBuffer stringBuffer = new StringBuffer();
                devRepairdetailDao.findAllByRepairid(devRepair.getId()).forEach(devRepairdetail -> {
                    stringBuffer.append(devRepairdetail.getDevId());
                    stringBuffer.append("Ǵ");
                    stringBuffer.append(devRepairdetail.getErrorDesc());
                    stringBuffer.append("Ǵ");
                    deviceIds.add(deviceLibraryDao.findByOldId(devRepairdetail.getDevId()).getId());
                });
                repairSendBill.setRepairDeviceCheckDetail(StringSplitUtil.idListToCheckString(deviceIds));
                repairSendBill.setRepairReciveCheckDetail(repairSendBill.getRepairDeviceCheckDetail());
                repairSendBill.setRepairDeviceDetail(stringBuffer.toString());
                repairSendBill.setRepairUsera(repairBill1.getRepairUsera());
                if (devRepair.getHandleUser()!=null&&userService.getUserByOldId(devRepair.getHandleUser())!=null) {
                    repairSendBill.setRepairUseraId(userService.getUserByOldId(devRepair.getHandleUser()).getUserId());
                }
                if (devRepair.getHandleConfirmUser()!=null&&userService.getUserByOldId(devRepair.getHandleConfirmUser())!=null) {
                    repairSendBill.setRepairUserbId(userService.getUserByOldId(devRepair.getHandleConfirmUser()).getUserId());
                }
                if (devRepair.getApplyUser()!=null&&userService.getUserByOldId(devRepair.getApplyUser())!=null) {
                    repairSendBill.setStartUseraId(userService.getUserByOldId(devRepair.getApplyUser()).getUserId());
                }
                if (devRepair.getApplyConfirmUser()!=null&&userService.getUserByOldId(devRepair.getApplyConfirmUser())!=null) {
                    repairSendBill.setStartUserbId(userService.getUserByOldId(devRepair.getApplyConfirmUser()).getUserId());
                }
                repairSendBill.setSendTime(repairBill1.getCreateTime());
                repairSendBill.setSendUnit(repairBill1.getSendUnit());
                repairSendBill.setTitle(devRepair.getTitle());
                repairSendBill.setOldId(devRepair.getId());
                RepairSendBill repairSendBill1 = repairSendBillDao.save(repairSendBill);
                //detail
            }
        });
    }

    /**
     * 维修退回业务转换
     */
    @Override
    public void moveRepairBack() {

    }

    public boolean checkcountname(String countname){
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher m = p.matcher(countname);
        if (m.find()) {
            return true;
        }
        return false;
    }
}
