package com.example.removetolocal.service.impl;

import com.example.removetolocal.newstorage.dao.StorageBillDao;
import com.example.removetolocal.newstorage.dao.TaskDao;
import com.example.removetolocal.newstorage.dao.TaskLogDao;
import com.example.removetolocal.newstorage.entity.StorageBill;
import com.example.removetolocal.newdevice.dao.DeviceLibraryDao;
import com.example.removetolocal.newstorage.bto.TaskBto;
import com.example.removetolocal.newstorage.entity.Task;
import com.example.removetolocal.newstorage.entity.TaskLog;
import com.example.removetolocal.newuser.dao.UserDao;
import com.example.removetolocal.olddevice.dao.DevOptlogDao;
import com.example.removetolocal.olddevice.domin.DevOptlog;
import com.example.removetolocal.oldentity.*;
import com.example.removetolocal.oldentity.dao.*;
import com.example.removetolocal.service.StorageService;
import com.example.removetolocal.service.UserService;
import com.example.removetolocal.utils.StringSplitUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

@Service
public class StorageServiceImpl implements StorageService {
    @Autowired
    DevInstorageDao devInstorageDao;
    @Autowired
    DevInstoragedetailDao devInstoragedetailDao;
    @Autowired
    StorageBillDao storageBillDao;
    @Autowired
    UserDao userDao;
    @Autowired
    SysFileDao sysFileDao;
    @Autowired
    UserService userService;
    @Autowired
    DevOptlogDao devOptlogDao;
    @Autowired
    DeviceLibraryDao deviceLibraryDao;
    @Autowired
    DevTaskmainDao devTaskmainDao;
    @Autowired
    DevTaskoperaterDao devTaskoperaterDao;
    @Autowired
    TaskDao taskDao;
    @Autowired
    DevTasklogDao devTasklogDao;
    @Autowired
    TaskLogDao taskLogDao;
    /**
     * 入库业务转换
     */
    @Override
    public void moveStorage() {
        taskDao.deleteAll();
        storageBillDao.deleteAll();
        //入库账单转换
        List<DevInstorage> devInstorages = devInstorageDao.findAll();
        devInstorages.forEach(devInstorage -> {
            if (devInstorage.getStatus()!=1) {
                StorageBill storageBill = new StorageBill();
                storageBill.setApprover(userService.getUserNameByOldId(devInstorage.getApprover()));
                storageBill.setApplyNumber(devInstorage.getApplyDocNo());
                storageBill.setReplayNumber(devInstorage.getReplyDocNo());
                storageBill.setCreateTime(devInstorage.getCreateTime());
                storageBill.setUpdateTime(devInstorage.getUpdateTime());
                if (devInstorage.getCreateUser() != null) {
                    if (userDao.findByOldCode(devInstorage.getCreateUser()) != null || userDao.findByOldId(devInstorage.getCreateUser()) != null) {
                        storageBill.setCreateUserId(userDao.findByOldCode(devInstorage.getCreateUser()) == null ? userDao.findByOldId(devInstorage.getCreateUser()).getUserId() : userDao.findByOldCode(devInstorage.getCreateUser()).getUserId());
                    }
                }
                if (devInstorage.getUpdateUser() != null) {
                    if (userDao.findByOldCode(devInstorage.getUpdateUser()) != null || userDao.findByOldId(devInstorage.getUpdateUser()) != null) {
                        storageBill.setUpdateUserId(userDao.findByOldCode(devInstorage.getUpdateUser()) == null ? userDao.findByOldId(devInstorage.getUpdateUser()).getUserId() : userDao.findByOldCode(devInstorage.getUpdateUser()).getUserId());
                    }
                }
                if (devInstorage.getAnnex() != null) {
                    List<Integer> ids = StringSplitUtil.fileIdSplit(devInstorage.getAnnex());
                    if (ids.size() > 0) {
                        SysFile sysFile = sysFileDao.findById(ids.get(0)).get();
                        storageBill.setFileName(sysFile.getFilename());
                        storageBill.setFileUrl(sysFile.getFilepath());
                    }
                }
                storageBill.setReceiveUseraId(userService.getUserByOldId(devInstorage.getHandle()).getUserId());
                storageBill.setSendTime(devInstorage.getIssueTime());
                storageBill.setUpdateTime(devInstorage.getIssueTime());
                storageBill.setUpdateUserId(storageBill.getCreateUserId());
                if (devInstorage.getIssueUnit() != null) {
                    storageBill.setSendUnit(userService.getUnitNameByOldId(devInstorage.getIssueUnit()));
                }
                if (devInstorage.getSender() != null) {
                    storageBill.setSendUserId(userService.getUserNameByOldId(devInstorage.getSender()));
                }
                storageBill.setStorageStatus(2);
                storageBill.setStoragingCount(devInstorage.getTotal());
                storageBill.setStoragedCount(devInstorage.getTotal());
                //根据日志找到所有入库的装备
                List<Integer> deviceOldIds = devOptlogDao.findAllByBillidAndOptType(devInstorage.getId(),12).stream()
                        .map(DevOptlog::getDevId)
                        .collect(Collectors.toList());
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("x");
                deviceOldIds.forEach(integer -> {
                    if (deviceLibraryDao.findByOldId(integer)!=null){
                        stringBuffer.append(deviceLibraryDao.findByOldId(integer).getId());
                        stringBuffer.append("x");
                    }
                });
                storageBill.setStorageDetail(stringBuffer.toString());
                storageBill.setOldId(devInstorage.getId());
                StorageBill storageBill1 = storageBillDao.save(storageBill);
                //task转换
                DevTaskmain devTaskmain = devTaskmainDao.findByTypeAndResourceId(12,devInstorage.getId());
                if (devTaskmain.getIsComplete()==1||devTaskmain.getIsSeal()==1) {
                    TaskBto taskBto = devTaskmain.parseToTaskBto();
                    taskBto.setBillId(storageBill1.getId());
                    taskBto.setOldId(devTaskmain.getId());
                    Task task = taskDao.save(taskBto.toDo());
                    //添加业务日志
                    List<DevTasklog> devTasklogs = devTasklogDao.findAllByTaskId(devTaskmain.getId());
                    devTasklogs.forEach(devTasklog -> {
                        TaskLog taskLog = new TaskLog();
                        taskLog.setCreateTime(devTasklog.getOperateTime());
                        taskLog.setCreateUserId(userService.getUserByOldId(devTasklog.getOperater()).getUserId());
                        taskLog.setUpdateTime(taskLog.getCreateTime());
                        taskLog.setUpdateUserId(taskLog.getCreateUserId());
                        taskLog.setFileDetail("Ǵ");
                        taskLog.setRemark(devTasklog.getNote());
                        taskLog.setTaskId(task.getId());
                        taskLog.setOldId(devTasklog.getId());
                        taskLogDao.save(taskLog);
                    });
                }
            }
        });
    }
}
