package com.example.removetolocal.task;

import com.example.removetolocal.service.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

import java.util.Arrays;

@Slf4j
@Component
public class changeRun implements CommandLineRunner {

    @Autowired
    UserService userService;

    @Autowired
    DeviceService deviceService;

    @Autowired
    StorageService storageService;

    @Autowired
    MysqlToSTService mysqlToSTService;

    @Autowired
    SelfCheckService selfCheckService;

    @Autowired
    AllotService allotService;

    /**
     * Callback used to run the bean.
     *
     * @param args incoming main method arguments
     * @throws Exception on error
     */
    @Override
    public void run(String... args) throws Exception {
        userService.changeEntity();
        userService.updateUserPass();
        userService.setUserRole();
        log.info("用户模块数据迁移完成");
        deviceService.deviceChange();
        deviceService.sortPack();
        log.info("zb模块数据迁移完成");
        storageService.moveStorage();
        log.info("入库业务数据迁移完成");
        selfCheckService.moveSelfCheck();
        log.info("自查业务数据迁移完成");
        allotService.moveAllot();
        log.info("配发业务数据迁移完成");
        allotService.moveBack();
        log.info("退回业务数据迁移完成");
        mysqlToSTService.dbToDb();
        log.info("数据全部迁移成功！");
    }
}
