package com.example.removetolocal.newentity.dao;

import com.tykj.dev.device.library.subject.domin.DeviceLibrary;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

import java.util.Date;
import java.util.List;

/**
 * @author dengdiyi
 */
@SuppressWarnings("SqlResolve")
public interface DeviceLibraryDao extends JpaRepository<DeviceLibrary, Integer>, JpaSpecificationExecutor<DeviceLibrary> {

    List<DeviceLibrary> getAllByModel(String model);

    List<DeviceLibrary> getAllByOwnUnit(String unit);

    List<DeviceLibrary> getAllByTypeAndNameAndModel(Integer type, String name, String model);


    /**
     * 根据装备型号与装备所在地(多个地区)查询装备数量
     *
     * @param model     装备型号
     * @param locations 装备所在地列表
     * @return 装备数量
     */
    int countByModelAndLocationUnitIn(String model, List<String> locations);

    /**
     * 根据装备型号与装备所在地(一个地区)查询装备数量
     *
     * @param model    装备型号
     * @param location 装备所在地
     * @return 装备数量
     */
    int countByModelAndLocationUnit(String model, String location);


    List<DeviceLibrary> getAllByPartParentIdAndIsPart(Integer parentId, Integer isPart);

    List<DeviceLibrary> getAllByRfidCardId(String rfidCardId);

    @Query(nativeQuery = true, value = "select * from device_library where id in :idList")
    List<DeviceLibrary> getDeviceLibraryEntitiesByIdIn(@Param("idList") List<Integer> idList);

    List<DeviceLibrary> getAllByRfidSurfaceId(String rfid);

    @Query("select o from DeviceLibrary o where o.ownUnit= :unitName and o.createTime >= :startTime and o.createTime <= :endTime")
    List<DeviceLibrary> findAllByUnitBetweenTime(String unitName, Date startTime, Date endTime);

    List<DeviceLibrary> getAllByPackingId(Integer packingId);
}
