package com.example.removetolocal.newentity.dao;

import com.example.removetolocal.newentity.Task;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;

import java.util.List;
import java.util.Optional;

/**
 * @author dengdiyi
 */
public interface TaskDao extends JpaRepository<Task, Integer>, JpaSpecificationExecutor<Task> {

    /**
     * @param billId       账单id
     * @param businessType 业务类型
     *                     根据账单Id和业务类型查询task
     */
    Optional<Task> findByBillIdAndBusinessType(Integer billId, Integer businessType);

    /**
     * 根据账单id、业务类型、任务状态查询task
     *
     * @param billId       账单id
     * @param businessType 业务类型
     * @param billStatus   任务状态
     */
    List<Task> findAllByBillIdAndBusinessTypeAndBillStatus(Integer billId, Integer businessType, Integer billStatus);

    /**
     * 根据账单id、业务类型、任务状态查询task
     *
     * @param billId       账单id
     * @param businessType 业务类型
     */
    List<Task> findAllByBillIdAndBusinessType(Integer billId, Integer businessType);



    /**
     * 根据账单id、业务类型、以及父id为null
     *
     * @param billId       账单ID
     * @param businessType 业务类型
     */
    Task findAllByParentTaskIdIsNullAndBillIdAndBusinessType(Integer billId, Integer businessType);

    List<Task> findAllByParentTaskId(Integer parentTaskId);

    @Query("select o.billId from Task o where o.id=?1")
    Integer findBillIdByTaskId(int taskId);

    @Query("select o.billId from Task  o where  o.id=?1 and o.businessType=?2")
    Integer findBillId(int id, int businessType);

    @Query("select o.billId from Task o where o.parentTaskId = ?1 and o. businessType = ?2")
    Integer findBillIdByParentId(int parentTaskId, int businessType);

    List<Task> findTaskEntitiesByParentTaskId(Integer parentTaskId);

    Task findByBusinessTypeAndOwnUnitAndBillStatus(Integer type, Integer ownUnit, Integer billStatus);

    Task findByParentTaskIdAndAndTitle(Integer parentId, String title);

    List<Task> findAllByBusinessType(Integer businessType);
}
