package com.example.removetolocal.newuser.domin;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;
import java.util.Date;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName Mgrcert.java
 * @Description 证书
 * @createTime 2020年08月06日 14:48:00
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
@Entity
public class Mgrcert {
    /**
     * id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Integer id;
    /**
     * 持件人名称
     */
    private String name;
    /**
     * 持件人id
     */
    @Column(name = "user_id")
    private Integer userId;
    /**
     * 证书编号
     */
    @Column(name = "cert_num")
    private Integer certNum = 123412312;
    /**
     * 颁发日期
     */
    @Column(name = "cert_date")
    private Date issueDate;
    /**
     * 失效日期
     */
    @Column(name = "expiry_date")
    private Date expiryDate;
    /**
     * 是否失效 默认0 1失效
     */
    @Column(name = "is_expiry")
    private Integer isExpiry;
    /**
     * 证书名称
     */
    @Column(name = "cert_name")
    private String certName;

    @Column(name = "old_id")
    private Integer oldId;

}
