package com.example.removetolocal.service.impl;

import com.example.removetolocal.newuser.dao.AreaDao;
import com.example.removetolocal.newuser.dao.MgrcertDao;
import com.example.removetolocal.newuser.dao.UnitsDao;
import com.example.removetolocal.newuser.dao.UserDao;
import com.example.removetolocal.newuser.domin.Area;
import com.example.removetolocal.newuser.domin.Mgrcert;
import com.example.removetolocal.newuser.domin.Units;
import com.example.removetolocal.newuser.domin.User;
import com.example.removetolocal.olduser.dao.*;
import com.example.removetolocal.olduser.domin.*;
import com.example.removetolocal.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

@Service
public class UserServiceImpl implements UserService {

    @Autowired
    DevAreaDao devAreaDao;
    @Autowired
    DevManagerDao devManagerDao;
    @Autowired
    DevMgrcertDao devMgrcertDao;
    @Autowired
    SysCompanyDao sysCompanyDao;
    @Autowired
    SysUserDao sysUserDao;
    @Autowired
    UserDao userDao;
    @Autowired
    UnitsDao unitsDao;
    @Autowired
    MgrcertDao mgrcertDao;
    @Autowired
    AreaDao areaDao;
    /**
     * 区域、部门、用户
     */
    @Override
    public void changeEntity() {
        //转换区域
        //找到最高级
        DevAreaEntity devAreaEntity = devAreaDao.findByPid("0");
        //浙江省
        DevAreaEntity devAreaEntity1 = devAreaDao.findByPid(devAreaEntity.getId());
        Area area = new Area();
        area.setName(devAreaEntity1.getAreaname());
        area.setOrders(String.valueOf(devAreaEntity1.getShoworder()));
        area.setOldId(devAreaEntity1.getId());
        area.setType(devAreaEntity1.getLevel());
        Area area1 = areaDao.save(area);
        Integer fatherId = area1.getId();
        changeUnitsByArea(devAreaEntity1.getId(),fatherId);
        changeByFatherArea(devAreaEntity1.getId(),fatherId);
    }

    /**
     * @param oldFatherId 旧表父类Id
     * @param newFatherId 新表父类id
     * 递归转换父类旗下所有区域
     */
    void changeByFatherArea(String oldFatherId,Integer newFatherId){
        List<DevAreaEntity> devAreaEntityList = devAreaDao.findAllByPid(oldFatherId);
        if (devAreaEntityList.size()>0){
            devAreaEntityList.forEach(areaEntity -> {
                Area area2 = new Area();
                area2.setName(areaEntity.getAreaname());
                area2.setOrders(String.valueOf(areaEntity.getShoworder()));
                area2.setOldId(areaEntity.getId());
                area2.setType(areaEntity.getLevel());
                area2.setFatherId(newFatherId);
                Area area = areaDao.save(area2);
                changeByFatherArea(areaEntity.getId(),area.getId());
                changeUnitsByArea(areaEntity.getId(),area.getId());
            });
        }
    }

    /**
     * @param oldAreaId 旧表区域Id
     * @param newAreaId 新表区域Id
     * 转换区域下所有单位
     */
    void changeUnitsByArea(String oldAreaId,Integer newAreaId){
        List<SysCompanyEntity> sysCompanyEntities = sysCompanyDao.findAllByAreaId(oldAreaId);
        if (sysCompanyEntities.size()>0){
            sysCompanyEntities.forEach(sysCompanyEntity -> {
                Units units = new Units();
                units.setName(sysCompanyEntity.getCompanyName());
                units.setUnitDesc(sysCompanyEntity.getCompanyDesc());
                units.setLevel(sysCompanyEntity.getLevel());
                units.setIdDel(sysCompanyEntity.getIsdel());
                units.setCode(sysCompanyEntity.getCode());
                units.setOldId(sysCompanyEntity.getCompanyId());
                if (sysCompanyEntity.getLevel()==2) {
                    units.setAreaId(newAreaId);
                }
                //区县
                else if (sysCompanyEntity.getLevel()==3){
                    //添加新区域
                    Area area = new Area();
                    area.setType(3);
                    area.setOrders("1");
                    area.setFatherId(newAreaId);
                    area.setName(sysCompanyEntity.getCompanyName().substring(0,3));
                    Area area1 = areaDao.save(area);
                    units.setAreaId(area1.getId());
                }
                Units units1 = unitsDao.save(units);
                changeUsersByUnit(sysCompanyEntity.getCompanyId(), units1.getUnitId());
            });
        }
    }

    /**
     * @param oldUnitId 旧表单位Id
     * @param newUnitId 新表单位Id
     * 转换单位下所有专管员及证书
     */
    void changeUsersByUnit(String oldUnitId,Integer newUnitId){
        List<SysUserEntity> sysUserEntities = sysUserDao.findAllByCompanyId(oldUnitId);
        if (sysUserEntities.size()>0){
            sysUserEntities.forEach(sysUserEntity -> {
                User user = new User();
                List<DevManagerEntity> devManagerEntities = devManagerDao.findAllById(sysUserEntity.getCode());
                if (sysUserEntity.getCode()!=null&&!devManagerEntities.isEmpty()){
                    DevManagerEntity devManagerEntity = devManagerEntities.get(0);
                    user.setName(sysUserEntity.getUserName());
                    user.setPassword("123456");
                    user.setNoPassword("123456");
                    user.setUsername(sysUserEntity.getLoginid());
                    user.setShowOrder(sysUserEntity.getShoworder().intValue());
                    user.setMobile(devManagerEntity.getMobile());
                    user.setTelphone(devManagerEntity.getTel());
                    user.setEmail(sysUserEntity.getEmail());
                    user.setFax(sysUserEntity.getFax());
                    user.setIsDel(sysUserEntity.getIsdel());
                    user.setIdCard(sysUserEntity.getIdcardno());
                    user.setSex(sysUserEntity.getSex());
                    user.setUnitsId(newUnitId);
                    user.setPosition(1);
                    user.setOldId(sysUserEntity.getUserId());
                    user.setOldCode(devManagerEntity.getId());
                }
                else {
                    user.setName(sysUserEntity.getUserName());
                    user.setPassword("123456");
                    user.setNoPassword("123456");
                    user.setUsername(sysUserEntity.getLoginid());
                    if (sysUserEntity.getShoworder()!=null) {
                        user.setShowOrder(sysUserEntity.getShoworder().intValue());
                    }
                    user.setMobile(sysUserEntity.getMobile());
                    user.setTelphone(sysUserEntity.getTelphone());
                    user.setEmail(sysUserEntity.getEmail());
                    user.setFax(sysUserEntity.getFax());
                    user.setIsDel(sysUserEntity.getIsdel());
                    user.setIdCard(sysUserEntity.getIdcardno());
                    user.setSex(sysUserEntity.getSex());
                    user.setUnitsId(newUnitId);
                    user.setPosition(1);
                    user.setOldId(sysUserEntity.getUserId());
                    user.setOldCode("0");
                }
                User user1 = userDao.save(user);
                List<DevMgrcertEntity> devMgrcertEntities = new ArrayList<>();
                devMgrcertEntities.addAll(devMgrcertDao.findAllByCertMgr(String.valueOf(user1.getOldCode())));
                devMgrcertEntities.addAll(devMgrcertDao.findAllByCertMgr(String.valueOf(user1.getOldId())));
                if (devMgrcertEntities.size()>0){
                    DevMgrcertEntity devMgrcertEntity = devMgrcertEntities.get(0);
                    user1.setTrainStatus(0);
                    userDao.save(user1);
                    Mgrcert mgrcert = new Mgrcert();
                    mgrcert.setCertName(devMgrcertEntity.getName());
                    mgrcert.setUserId(user1.getUserId());
                    mgrcert.setCertNum(devMgrcertEntity.getCertNum());
                    mgrcert.setIssueDate(devMgrcertEntity.getIssueDate());
                    mgrcert.setExpiryDate(devMgrcertEntity.getExpiryDate());
                    mgrcert.setIsExpiry(devMgrcertEntity.getIsExpiry());
                    mgrcert.setName(user1.getName());
                    mgrcert.setOldId(devMgrcertEntity.getId());
                    mgrcertDao.save(mgrcert);
                }
                else {
                    user1.setTrainStatus(2);
                    userDao.save(user1);
                }
            });
        }
    }
}
