package com.example.removetolocal.newentity.entity;

import lombok.Data;
import javax.persistence.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for device_repel
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "device_repel")
public class DeviceRepel {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* describes
	*/
	@Column(name = "describes",columnDefinition = "TEXT")
	private String describes;
	/**
	* fielding
	*/
	@Column(name = "fielding",columnDefinition = "TEXT")
	private String fielding;
	/**
	* fineName
	*/
	@Column(name = "fine_name")
	private String fineName;
	/**
	* taskScope
	*/
	@Column(name = "task_scope",columnDefinition = "TEXT")
	private String taskScope;
	/**
	* time
	*/
	@Column(name = "time")
	private java.util.Date time;
	/**
	* url
	*/
	@Column(name = "url")
	private String url;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private java.util.Date createTime;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private java.util.Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* repelStatus
	*/
	@Column(name = "repel_status")
	private Integer repelStatus;
	/**
	* title
	*/
	@Column(name = "title")
	private String title;
	/**
	* files
	*/
	@Column(name = "files",columnDefinition = "TEXT")
	private String files;
	/**
	* initiateName
	*/
	@Column(name = "initiate_name")
	private String initiateName;
	/**
	* unitId
	*/
	@Column(name = "unit_id")
	private Integer unitId;
	/**
	* unitName
	*/
	@Column(name = "unit_name")
	private String unitName;

}
