package com.example.removetolocal.newentity.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.persistence.*;

/**
 * entity class for train_user
*/
@Data
@Entity
@AllArgsConstructor
@NoArgsConstructor
@Table(name = "train_user")
public class TrainUser {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* attendance
	*/
	@Column(name = "attendance")
	private String attendance;
	/**
	* certificate
	*/
	@Column(name = "certificate")
	private Integer certificate;
	/**
	* evaluation
	*/
	@Column(name = "evaluation")
	private String evaluation;
	/**
	* idCard
	*/
	@Column(name = "id_card")
	private String idCard;
	/**
	* isNotJoinUserId
	*/
	@Column(name = "is_not_join_user_id")
	private Integer isNotJoinUserId;
	/**
	* isSignUp
	*/
	@Column(name = "is_sign_up")
	private Integer isSignUp;
	/**
	* mobile
	*/
	@Column(name = "mobile")
	private String mobile;
	/**
	* name
	*/
	@Column(name = "name")
	private String name;
	/**
	* note
	*/
	@Column(name = "note")
	private String note;
	/**
	* position
	*/
	@Column(name = "position")
	private Integer position;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;
	/**
	* score
	*/
	@Column(name = "score")
	private String score;
	/**
	* sex
	*/
	@Column(name = "sex")
	private Integer sex;
	/**
	* trainId
	*/
	@Column(name = "train_id")
	private Integer trainId;
	/**
	* unitsId
	*/
	@Column(name = "units_id")
	private Integer unitsId;
	/**
	* unitsName
	*/
	@Column(name = "units_name")
	private String unitsName;
	/**
	* userId
	*/
	@Column(name = "user_id")
	private Integer userId;


	public TrainUser(Integer trainId, Integer userId, String name, String mobile, String idCard, Integer sex, Integer position, String unitsName, Integer unitsId, String attendance, String score, String evaluation, Integer isSignUp, String note, Integer certificate, Integer isNotJoinUserId) {
		this.trainId = trainId;
		this.userId = userId;
		this.name = name;
		this.mobile = mobile;
		this.idCard = idCard;
		this.sex = sex;
		this.position = position;
		this.unitsName = unitsName;
		this.unitsId = unitsId;
		this.attendance = attendance;
		this.score = score;
		this.evaluation = evaluation;
		this.isSignUp = isSignUp;
		this.note = note;
		this.certificate = certificate;
		this.isNotJoinUserId = isNotJoinUserId;
	}
}
