package com.example.removetolocal.newrepair.entity;

import com.example.removetolocal.config.BeanHelper;
import lombok.Data;
import javax.persistence.*;

import org.modelmapper.ModelMapper;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for repair_detail
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "repair_detail")
public class RepairDetail {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* createTime
	*/
	@Column(name = "create_time")
	@CreatedDate
	private java.util.Date createTime;
	/**
	* createUserId
	*/
	@Column(name = "create_user_id")
	@CreatedBy
	private Integer createUserId;
	/**
	* deleteTag
	*/
	@Column(name = "delete_tag")
	private Integer deleteTag = 0;
	/**
	* deviceId
	*/
	@Column(name = "device_id")
	private Integer deviceId;
	/**
	* deviceRepairBillId
	*/
	@Column(name = "device_repair_bill_id")
	private Integer deviceRepairBillId;
	/**
	* locationUnit
	*/
	@Column(name = "location_unit")
	private String locationUnit;
	/**
	* model
	*/
	@Column(name = "model")
	private String model;
	/**
	* name
	*/
	@Column(name = "name")
	private String name;
	/**
	* newDeviceDetailId
	*/
	@Column(name = "new_device_detail_id")
	private Integer newDeviceDetailId;
	/**
	* ownUnit
	*/
	@Column(name = "own_unit")
	private String ownUnit;
	/**
	* recordId
	*/
	@Column(name = "record_id")
	private String recordId;
	/**
	* remark
	*/
	@Column(name = "remark")
	private String remark;
	/**
	* repairStatus
	*/
	@Column(name = "repair_status")
	private Integer repairStatus;
	/**
	* rfidSurfaceId
	*/
	@Column(name = "rfid_surface_id")
	private String rfidSurfaceId;
	/**
	* seqNumber
	*/
	@Column(name = "seq_number")
	private String seqNumber;
	/**
	* type
	*/
	@Column(name = "type")
	private Integer type;
	/**
	* updateTime
	*/
	@Column(name = "update_time")
	@LastModifiedDate
	private java.util.Date updateTime;
	/**
	* updateUserId
	*/
	@Column(name = "update_user_id")
	@LastModifiedBy
	private Integer updateUserId;
	/**
	* record
	*/
	@Column(name = "record")
	private String record;
	/**
	* repairBackBillId
	*/
	@Column(name = "repair_back_bill_id")
	private Integer repairBackBillId;
	/**
	* record2
	*/
	@Column(name = "record2")
	private String record2;
	/**
	* record3
	*/
	@Column(name = "record3")
	private String record3;
	/**
	* pid
	*/
	@Column(name = "pid")
	private Integer pid;

	@Column(name = "old_id")
	private Integer oldId;

	public com.example.removetolocal.newentity.entity.RepairDetail toST() {
		ModelMapper mapper = BeanHelper.getUserMapper();
		return mapper.map(this, com.example.removetolocal.newentity.entity.RepairDetail.class);
	}
}
