package com.example.removetolocal.newrepel.entity;

import com.example.removetolocal.config.BeanHelper;
import com.fasterxml.jackson.annotation.JsonFormat;

import lombok.Data;
import org.modelmapper.ModelMapper;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Date;

/**
 * @author zjm
 * @version 1.0.0
 * @ClassName DeviceRepel.java
 * @Description DeviceRepel 清退业务id
 * @createTime 2021年01月06日 20:02:00
 */
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "device_repel_detail")
public class DeviceRepelDetail extends BaseEntity {
    /**
     * 主键id
     */
    @Id
    @GeneratedValue
    @Column(name = "id")
    private Integer id;

    /**
     * 账单id
     */
    @Column(name = "repel_id")
    private Integer repelId;

    /**
     * 编号
     */
    @Column(name = "num")
    private String num;

    /**
     * 申请文号
     */
    @Column(name = "apply_number")
    private String applyNumber;
    /**
     * 批复文号
     */
    @Column(name = "replay_number")
    private String replayNumber;
    /**
     * 发件单位
     */
    @Column(name = "send_unit")
    private String sendUnit;

    /**
     * 发件单位id
     */
    @Column(name = "send_unit_id")
    private Integer sendUnitId;

    /**
     * 收件单位id
     */
    @Column(name = "receive_unit_id")
    private Integer receiveUnitId;
    /**
     * 收件单位
     */
    @Column(name = "receive_unit")
    private String receiveUnit;
    /**
     * 配发时间
     */
    @Column(name = "send_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date sendTime;
    /**
     * 接收时间
     */
    @Column(name = "receive_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date receiveTime;
    /**
     * 经办人
     */
    @Column(name = "send_useraid")
    private Integer sendUserAId;

    /**
     * 经办人 名称
     */
    @Column(name = "send_useraname")
    private String sendUserAName;

    /**
     * 签发人
     */
    @Column(name = "send_userbname")
    private String sendUserBName;

    /**
     * 签发人 id
     */
    @Column(name = "send_userbid")
    private Integer sendUserBId;

    /**
     * 收件方 经办人
     */
    @Column(name = "receive_useraid")
    private Integer receiveUserAId;

    /**
     * 收件方 经办人名称
     */
    @Column(name = "receive_useraname")
    private String receiveUserAName;

    /**
     * 收件方id(B岗位)
     */
    @Column(name = "receive_userbname")
    private String receiveUserBName;
    /**
     * 收件方id(B岗位)
     */
    @Column(name = "receive_userbid")
    private Integer receiveUserBId;

    /**
     * 出库附件文件
     */
    @Column(name = "outbound_file",columnDefinition = "TEXT")
    private String outboundFile;

    /**
     * 清退单文件
     */
    @Column(name = "bill_file",columnDefinition = "TEXT")
    private String billFile;

    /**
     * 入库确认单
     */
    @Column(name = "in_file",columnDefinition = "TEXT")
    private String inFile;

    /**
     * 退回状态(1:退回待审核,2:退回审核失败,3:退回中,4:退回接收待审核,5:退回接收审核失败,6:退回成功)
     */
    @Column(name = "send_back_status")
    private Integer sendBackStatus;
    /**
     * 退回装备数量
     */
    @Column(name = "send_back_count")
    private Integer sendBackCount;
    /**
     * 已出库装备数量
     */
    @Column(name = "sended_count")
    private Integer sendedCount;
    /**
     * 已接收装备数量
     */
    @Column(name = "receive_count")
    private Integer receiveCount;
    /**
     * 出库检查详情(装备主键id+核对结果(0缺失1无误3新增,字符x作为分隔符)),例如x10x21x32x,意为主键id为1的装备缺失,为2的无误,为3的不匹配
     */
    @Column(name = "send_check_detail",columnDefinition = "TEXT")
    private String sendCheckDetail;
    /**
     * 出库检查结果(缺失数量x新增数量),例如1x1,意为缺失1台,新增一条
     */
    @Column(name = "send_check_result",columnDefinition = "TEXT")
    private String sendCheckResult;

    /**
     * 接收方入库检查详情(装备主键id+核对结果(0缺失1无误3不匹配,字符x作为分隔符)),例如x10x21x32x,意为主键id为1的装备缺失,为2的无误,为3的不匹配
     */
    @Column(name = "receive_check_detail",columnDefinition = "TEXT")
    private String receiveCheckDetail;

    /**
     * 接收方检查结果(缺失数量x新增数量),例如1x1,意为缺失1台,新增一条
     */
    @Column(name = "receive_check_result",columnDefinition = "TEXT")
    private String receiveCheckResult;

    @Column(name = "device_ids",columnDefinition = "TEXT")
    private String deviceIds;

    private String leftSignatureId;

    private String rightSignatureId;

    private String recordId;

    /**
     * 提交描述
     */
    @Column(name = "submit_description",columnDefinition = "TEXT")
    private String submitDescription;
    /**
     * 审核反馈
     */
    @Column(name = "auditing_feedback",columnDefinition = "TEXT")
    private String auditingFeedback;

    @Column(name = "repel_status")
    private Integer repelStatus;


    public DeviceRepelDetail(Integer repelId, String num, String applyNumber, String replayNumber, String sendUnit, Integer sendUnitId, Integer receiveUnitId, String receiveUnit, Date sendTime, Date receiveTime, Integer sendUserAId, String sendUserAName, String sendUserBName, Integer receiveUserAId, String receiveUserAName, String receiveUserBName, Integer receiveUserBId, String outboundFile, String billFile, String inFile, Integer sendBackStatus, Integer sendBackCount, Integer sendedCount, Integer receiveCount, String sendCheckDetail, String sendCheckResult, String receiveCheckDetail, String receiveCheckResult, String deviceIds, String leftSignatureId, String rightSignatureId, String recordId, String submitDescription, String auditingFeedback, Integer repelStatus) {
        this.repelId = repelId;
        this.num = num;
        this.applyNumber = applyNumber;
        this.replayNumber = replayNumber;
        this.sendUnit = sendUnit;
        this.sendUnitId = sendUnitId;
        this.receiveUnitId = receiveUnitId;
        this.receiveUnit = receiveUnit;
        this.sendTime = sendTime;
        this.receiveTime = receiveTime;
        this.sendUserAId = sendUserAId;
        this.sendUserAName = sendUserAName;
        this.sendUserBName = sendUserBName;
        this.receiveUserAId = receiveUserAId;
        this.receiveUserAName = receiveUserAName;
        this.receiveUserBName = receiveUserBName;
        this.receiveUserBId = receiveUserBId;
        this.outboundFile = outboundFile;
        this.billFile = billFile;
        this.inFile = inFile;
        this.sendBackStatus = sendBackStatus;
        this.sendBackCount = sendBackCount;
        this.sendedCount = sendedCount;
        this.receiveCount = receiveCount;
        this.sendCheckDetail = sendCheckDetail;
        this.sendCheckResult = sendCheckResult;
        this.receiveCheckDetail = receiveCheckDetail;
        this.receiveCheckResult = receiveCheckResult;
        this.deviceIds = deviceIds;
        this.leftSignatureId = leftSignatureId;
        this.rightSignatureId = rightSignatureId;
        this.recordId = recordId;
        this.submitDescription = submitDescription;
        this.auditingFeedback = auditingFeedback;
        this.repelStatus = repelStatus;
    }

    public com.example.removetolocal.newentity.entity.DeviceRepelDetail toST() {
        ModelMapper mapper = BeanHelper.getUserMapper();
        return mapper.map(this, com.example.removetolocal.newentity.entity.DeviceRepelDetail.class);
    }
}
