package com.example.removetolocal.oldentity;

import lombok.Data;
import javax.persistence.*;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.hibernate.annotations.SQLDelete;
import org.hibernate.annotations.Where;
import java.util.Date;
import org.springframework.data.annotation.CreatedBy;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedBy;
import org.springframework.data.annotation.LastModifiedDate;

/**
 * entity class for dev_instoragedetail
 * 入库明细
*/
@Data
@Entity
@EntityListeners(AuditingEntityListener.class)
@Table(name = "dev_instoragedetail")
public class DevInstoragedetail {

	/**
	* id
	*/
	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	@Column(name = "id")
	private Integer id;
	/**
	* pid
	*/
	@Column(name = "pid")
	private Integer pid;
	/**
	* 入库单ID
	*/
	@Column(name = "insId")
	private Integer insId;
	/**
	* 列装设备ID
	*/
	@Column(name = "catalogId")
	private Integer catalogId;
	/**
	* 型号
	*/
	@Column(name = "model")
	private String model;
	/**
	* sernum
	*/
	@Column(name = "sernum")
	private String sernum;
	/**
	* pronum
	*/
	@Column(name = "pronum")
	private String pronum;
	/**
	* 类型  横向  纵向 代管
	*/
	@Column(name = "type")
	private Integer type;
	/**
	* 入库数量
	*/
	@Column(name = "num")
	private Integer num;
	/**
	* 序列号是否自动生成
	*/
	@Column(name = "isAutoGen")
	private Boolean isAutoGen;

}
